/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.KapFilterRel;
import org.apache.kylin.query.relnode.KapJoinRel;
import org.apache.kylin.query.relnode.KapProjectRel;
import org.apache.kylin.query.util.RuleUtils;

public class KapAggProjectMergeRule
extends RelOptRule {
    public static final KapAggProjectMergeRule AGG_PROJECT_JOIN = new KapAggProjectMergeRule(KapAggProjectMergeRule.operand(KapAggregateRel.class, (RelOptRuleOperand)KapAggProjectMergeRule.operand(KapProjectRel.class, (RelOptRuleOperand)KapAggProjectMergeRule.operand(KapJoinRel.class, (RelOptRuleOperandChildren)KapAggProjectMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "KapAggProjectMergeRule:agg-project-join");
    public static final KapAggProjectMergeRule AGG_PROJECT_FILTER_JOIN = new KapAggProjectMergeRule(KapAggProjectMergeRule.operand(KapAggregateRel.class, (RelOptRuleOperand)KapAggProjectMergeRule.operand(KapProjectRel.class, (RelOptRuleOperand)KapAggProjectMergeRule.operand(KapFilterRel.class, (RelOptRuleOperand)KapAggProjectMergeRule.operand(KapJoinRel.class, (RelOptRuleOperandChildren)KapAggProjectMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "KapAggProjectMergeRule:agg-project-filter-join");

    public KapAggProjectMergeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    public KapAggProjectMergeRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    public KapAggProjectMergeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public boolean matches(RelOptRuleCall call) {
        KapJoinRel joinRel;
        KapJoinRel kapJoinRel = joinRel = call.rel(2) instanceof KapFilterRel ? (KapJoinRel)call.rel(3) : (KapJoinRel)call.rel(2);
        if (!RuleUtils.isJoinOnlyOneAggChild(joinRel)) {
            return false;
        }
        KapAggregateRel aggregate = (KapAggregateRel)call.rel(0);
        KapProjectRel project = (KapProjectRel)call.rel(1);
        ImmutableBitSet.Builder immutableBitSetBuilder = ImmutableBitSet.builder();
        immutableBitSetBuilder.addAll(aggregate.getGroupSet());
        aggregate.getAggCallList().forEach(aggregateCall -> {
            ImmutableBitSet args = ImmutableBitSet.of((Iterable)aggregateCall.getArgList());
            immutableBitSetBuilder.addAll(args);
        });
        ImmutableBitSet hasUseInAgg = immutableBitSetBuilder.build();
        for (int i = 0; i < project.getProjects().size(); ++i) {
            RexNode rexNode = (RexNode)project.getProjects().get(i);
            if (rexNode instanceof RexInputRef || !hasUseInAgg.get(i)) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        KapProjectRel project;
        KapAggregateRel aggregate = (KapAggregateRel)call.rel(0);
        RelNode x = KapAggProjectMergeRule.apply(call, (Aggregate)aggregate, (Project)(project = (KapProjectRel)call.rel(1)));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(RelOptRuleCall call, Aggregate aggregate, Project project) {
        ArrayList newKeys = Lists.newArrayList();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            RexNode rex = (RexNode)project.getProjects().get(key);
            if (!(rex instanceof RexInputRef)) continue;
            int newKey = ((RexInputRef)rex).getIndex();
            newKeys.add(newKey);
            map.put(key, newKey);
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList newGroupingSets = null;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute((Iterable)aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            ImmutableList.Builder newArgs = ImmutableList.builder();
            Iterator iterator2 = aggregateCall.getArgList().iterator();
            while (iterator2.hasNext()) {
                int arg = (Integer)iterator2.next();
                RexNode rex = (RexNode)project.getProjects().get(arg);
                if (!(rex instanceof RexInputRef)) {
                    return null;
                }
                newArgs.add((Object)((RexInputRef)rex).getIndex());
            }
            int newFilterArg = -1;
            if (aggregateCall.filterArg >= 0 && project.getProjects().get(aggregateCall.filterArg) instanceof RexInputRef) {
                newFilterArg = ((RexInputRef)project.getProjects().get(aggregateCall.filterArg)).getIndex();
            }
            aggCalls.add((Object)aggregateCall.copy((List)newArgs.build(), newFilterArg));
        }
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), aggregate.indicator, newGroupSet, (List)newGroupingSets, (List)aggCalls.build());
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)newAggregate);
        KapAggProjectMergeRule.processNewKeyNotExists(relBuilder, newKeys, newGroupSet, aggregate, newAggregate);
        return relBuilder.build();
    }

    private static void processNewKeyNotExists(RelBuilder relBuilder, List<Integer> newKeys, ImmutableBitSet newGroupSet, Aggregate aggregate, Aggregate newAggregate) {
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList posList = Lists.newArrayList();
            for (int newKey : newKeys) {
                posList.add(newGroupSet.indexOf(newKey));
            }
            if (aggregate.indicator) {
                for (int newKey : newKeys) {
                    posList.add(aggregate.getGroupCount() + newGroupSet.indexOf(newKey));
                }
            }
            for (int i = newAggregate.getGroupCount() + newAggregate.getIndicatorCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            relBuilder.project((Iterable)relBuilder.fields((List)posList));
        }
    }
}

