/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.KapFilterRel;
import org.apache.kylin.query.relnode.KapJoinRel;
import org.apache.kylin.query.util.RuleUtils;

public class KapAggFilterTransposeRule
extends RelOptRule {
    public static final KapAggFilterTransposeRule AGG_FILTER_JOIN = new KapAggFilterTransposeRule(KapAggFilterTransposeRule.operand(KapAggregateRel.class, (RelOptRuleOperand)KapAggFilterTransposeRule.operand(KapFilterRel.class, (RelOptRuleOperand)KapAggFilterTransposeRule.operand(KapJoinRel.class, (RelOptRuleOperandChildren)KapAggFilterTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "KapAggFilterTransposeRule:agg-filter-join");

    public KapAggFilterTransposeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    public KapAggFilterTransposeRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    public KapAggFilterTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public boolean matches(RelOptRuleCall call) {
        KapJoinRel joinRel = (KapJoinRel)call.rel(2);
        return RuleUtils.isJoinOnlyOneAggChild(joinRel);
    }

    public void onMatch(RelOptRuleCall call) {
        KapAggregateRel aggregate = (KapAggregateRel)call.rel(0);
        KapFilterRel filter = (KapFilterRel)call.rel(1);
        ImmutableBitSet filterColumns = RelOptUtil.InputFinder.bits((RexNode)filter.getCondition());
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().union(filterColumns);
        RelNode input = filter.getInput();
        RelMetadataQuery mq = call.getMetadataQuery();
        Boolean unique = mq.areColumnsUnique(input, newGroupSet);
        if (unique != null && unique.booleanValue()) {
            return;
        }
        boolean allColumnsInAggregate = aggregate.getGroupSet().contains(filterColumns);
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), input, false, newGroupSet, null, aggregate.getAggCallList());
        Mappings.TargetMapping mapping = Mappings.target(arg_0 -> ((ImmutableBitSet)newGroupSet).indexOf(arg_0), (int)input.getRowType().getFieldCount(), (int)newGroupSet.cardinality());
        RexNode newCondition = RexUtil.apply((Mappings.TargetMapping)mapping, (RexNode)filter.getCondition());
        Filter newFilter = filter.copy(filter.getTraitSet(), (RelNode)newAggregate, newCondition);
        if (allColumnsInAggregate && aggregate.getGroupType() == Aggregate.Group.SIMPLE) {
            assert (newGroupSet.equals((Object)aggregate.getGroupSet()));
            call.transformTo((RelNode)newFilter);
            return;
        }
        ImmutableBitSet.Builder topGroupSet = ImmutableBitSet.builder();
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int c = (Integer)iterator.next();
            topGroupSet.set(newGroupSet.indexOf(c));
        }
        ImmutableList newGroupingSets2 = null;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            ImmutableList.Builder newGroupingSetsBuilder = ImmutableList.builder();
            for (ImmutableBitSet groupingSet : aggregate.getGroupSets()) {
                ImmutableBitSet.Builder newGroupingSet = ImmutableBitSet.builder();
                Iterator iterator2 = groupingSet.iterator();
                while (iterator2.hasNext()) {
                    int c = (Integer)iterator2.next();
                    newGroupingSet.set(newGroupSet.indexOf(c));
                }
                newGroupingSetsBuilder.add((Object)newGroupingSet.build());
            }
            newGroupingSets2 = newGroupingSetsBuilder.build();
        }
        ArrayList topAggCallList = Lists.newArrayList();
        int i = newGroupSet.cardinality();
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            SqlAggFunction rollup = SubstitutionVisitor.getRollup((SqlAggFunction)aggregateCall.getAggregation());
            if (rollup == null) {
                return;
            }
            if (aggregateCall.isDistinct()) {
                return;
            }
            topAggCallList.add(AggregateCall.create((SqlAggFunction)rollup, (boolean)aggregateCall.isDistinct(), (boolean)aggregateCall.isApproximate(), (List)ImmutableList.of((Object)i++), (int)-1, (RelDataType)aggregateCall.type, (String)aggregateCall.name));
        }
        Aggregate topAggregate = aggregate.copy(aggregate.getTraitSet(), (RelNode)newFilter, aggregate.indicator, topGroupSet.build(), (List)newGroupingSets2, (List)topAggCallList);
        call.transformTo((RelNode)topAggregate);
    }
}

