/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.kylin.query.relnode.KapFilterRel;

public class FilterSimplifyRule
extends RelOptRule {
    public static final FilterSimplifyRule INSTANCE = new FilterSimplifyRule(FilterSimplifyRule.operand(KapFilterRel.class, (RelOptRuleOperandChildren)FilterSimplifyRule.any()), RelFactories.LOGICAL_BUILDER, "FilterSimpifyRule");

    public FilterSimplifyRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        RelBuilder relBuilder = call.builder();
        boolean changed = false;
        LinkedList<RexNode> conjunctions = new LinkedList<RexNode>();
        for (RexNode conjunction : RelOptUtil.conjunctions((RexNode)filter.getCondition())) {
            RexNode simpified = this.simpiflyOrs(conjunction, relBuilder.getRexBuilder());
            if (simpified != conjunction) {
                changed = true;
            }
            conjunctions.add(simpified);
        }
        if (changed) {
            relBuilder.push(filter.getInput());
            relBuilder.filter(new RexNode[]{RexUtil.composeConjunction((RexBuilder)relBuilder.getRexBuilder(), conjunctions, (boolean)true)});
            call.transformTo(relBuilder.build());
        }
    }

    private RexNode simpiflyOrs(RexNode conjunction, RexBuilder rexBuilder) {
        List terms = RelOptUtil.disjunctions((RexNode)conjunction);
        HashMap<String, List<RexNode>> equals = new HashMap<String, List<RexNode>>();
        HashMap<String, List<Integer>> equalsIdxes = new HashMap<String, List<Integer>>();
        this.findPattern(terms, equals, equalsIdxes);
        LinkedList mergedTerms = new LinkedList();
        HashSet toRemoveIdxes = new HashSet();
        equalsIdxes.forEach((digest, idxes) -> {
            if (idxes.size() >= 5) {
                mergedTerms.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IN, (List)equals.get(digest)));
                toRemoveIdxes.addAll(idxes);
            }
        });
        if (toRemoveIdxes.isEmpty()) {
            return conjunction;
        }
        for (int i = 0; i < terms.size(); ++i) {
            if (toRemoveIdxes.contains(i)) continue;
            mergedTerms.add(terms.get(i));
        }
        return RexUtil.composeDisjunction((RexBuilder)rexBuilder, mergedTerms);
    }

    private void findPattern(List<RexNode> terms, HashMap<String, List<RexNode>> equals, HashMap<String, List<Integer>> equalsIdxes) {
        for (int i = 0; i < terms.size(); ++i) {
            if (!(terms.get(i) instanceof RexCall)) continue;
            RexCall call = (RexCall)terms.get(i);
            this.findEquals(equals, equalsIdxes, i, call);
        }
    }

    private void findEquals(HashMap<String, List<RexNode>> equals, HashMap<String, List<Integer>> equalsIdxes, int i, RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.EQUALS) {
            return;
        }
        RexNode op0 = (RexNode)call.getOperands().get(0);
        RexNode op1 = (RexNode)call.getOperands().get(1);
        if (op0 instanceof RexLiteral && !(op1 instanceof RexLiteral)) {
            if (!equals.containsKey(op1.toString())) {
                equals.put(op1.toString(), new ArrayList());
                equals.get(op1.toString()).add(op1);
                equalsIdxes.put(op1.toString(), new ArrayList());
            }
            equals.get(op1.toString()).add(op0);
            equalsIdxes.get(op1.toString()).add(i);
        } else if (!(op0 instanceof RexLiteral) && op1 instanceof RexLiteral) {
            if (!equals.containsKey(op0.toString())) {
                equals.put(op0.toString(), new ArrayList());
                equals.get(op0.toString()).add(op0);
                equalsIdxes.put(op0.toString(), new ArrayList());
            }
            equals.get(op0.toString()).add(op1);
            equalsIdxes.get(op0.toString()).add(i);
        }
    }
}

