/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;

public class AggregateProjectReduceRule
extends RelOptRule {
    public static final AggregateProjectReduceRule INSTANCE = new AggregateProjectReduceRule(AggregateProjectReduceRule.operand(LogicalAggregate.class, null, (Predicate)Aggregate.IS_SIMPLE, (RelOptRuleOperand)AggregateProjectReduceRule.operand(LogicalProject.class, (RelOptRuleOperandChildren)AggregateProjectReduceRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "AggregateProjectReduceRule");

    private AggregateProjectReduceRule(RelOptRuleOperand operand, RelBuilderFactory factory, String description) {
        super(operand, factory, description);
    }

    private void mappingKeys(int key, Pair<RexNode, String> project, List<Pair<RexNode, String>> projects, Map<Integer, Integer> mapping) {
        if (!projects.contains(project)) {
            projects.add(project);
        }
        mapping.put(key, projects.indexOf(project));
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalAggregate aggr = (LogicalAggregate)call.rel(0);
        LogicalProject project = (LogicalProject)call.rel(1);
        List projects = project.getNamedProjects();
        ArrayList<Pair<RexNode, String>> newProjects = new ArrayList<Pair<RexNode, String>>();
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        Iterator iterator = aggr.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.mappingKeys(key, (Pair<RexNode, String>)((Pair)projects.get(key)), newProjects, mapping);
        }
        ImmutableBitSet newGroupSet = aggr.getGroupSet().permute(mapping);
        ImmutableList.Builder newAggrCalls = ImmutableList.builder();
        for (AggregateCall aggrCall : aggr.getAggCallList()) {
            int newFilterArg;
            int key;
            ImmutableList.Builder newArgs = ImmutableList.builder();
            Iterator iterator2 = aggrCall.getArgList().iterator();
            while (iterator2.hasNext()) {
                key = (Integer)iterator2.next();
                this.mappingKeys(key, (Pair<RexNode, String>)((Pair)projects.get(key)), newProjects, mapping);
                newArgs.add(mapping.get(key));
            }
            if (aggrCall.filterArg > 0) {
                key = aggrCall.filterArg;
                this.mappingKeys(key, (Pair<RexNode, String>)((Pair)projects.get(key)), newProjects, mapping);
                newFilterArg = (Integer)mapping.get(aggrCall.filterArg);
            } else {
                newFilterArg = -1;
            }
            newAggrCalls.add((Object)aggrCall.copy((List)newArgs.build(), newFilterArg));
        }
        if (newProjects.equals(project.getNamedProjects())) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(project.getInput());
        relBuilder.project((Iterable)Pair.left(newProjects), (Iterable)Pair.right(newProjects));
        relBuilder.aggregate(relBuilder.groupKey(newGroupSet, false, null), (List)newAggrCalls.build());
        RelNode rel = relBuilder.build();
        call.transformTo(rel);
    }
}

