/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.routing.Candidate;
import org.junit.Test;

public class CandidateSortTest {
    @Test
    public void testCubeHintCandidateSort() {
        QueryContext queryContext = QueryContextFacade.current();
        queryContext.setCubePriorities(new String[0]);
        Candidate cube1 = this.mockCandidate("cube0001", "cubeA", 1, 1);
        Candidate cube2 = this.mockCandidate("cube0002", "cubeB", 2, 2);
        this.sort(cube1, cube2).assertFirst(cube1);
        queryContext.setCubePriorities(new String[]{"cubeb"});
        cube1 = this.mockCandidate("cube0001", "cubeA", 1, 1);
        cube2 = this.mockCandidate("cube0002", "cubeB", 2, 2);
        this.sort(cube1, cube2).assertFirst(cube2);
        queryContext.setCubePriorities(new String[]{"cubeb", "cubea"});
        cube1 = this.mockCandidate("cube0001", "cubeA", 1, 1);
        cube2 = this.mockCandidate("cube0002", "cubeB", 2, 2);
        this.sort(cube1, cube2).assertFirst(cube2);
        queryContext.setCubePriorities(new String[]{"cubec", "cubea"});
        cube1 = this.mockCandidate("cube0001", "cubeA", 1, 1);
        cube2 = this.mockCandidate("cube0002", "cubeB", 2, 2);
        Candidate cube3 = this.mockCandidate("cube0003", "cubeC", 4, 4);
        this.sort(cube1, cube2, cube3).assertFirst(cube3);
    }

    @Test
    public void testSort() {
        Candidate cube1 = this.mockCandidate("cube0001", "cubeA", 1, 1);
        Candidate cube2 = this.mockCandidate("cube0002", "cubeB", 2, 2);
        this.sort(cube1, cube2).assertFirst(cube1);
        cube1 = this.mockCandidate("cube0001", "cubeA", 2, 1);
        cube2 = this.mockCandidate("cube0002", "cubeB", 2, 2);
        this.sort(cube1, cube2).assertFirst(cube1);
        cube1 = this.mockCandidate("cube0001", "cubeA", 2, 2);
        cube2 = this.mockCandidate("cube0002", "cubeB", 2, 2);
        this.sort(cube1, cube2).assertFirst(cube1);
        cube1 = this.mockCandidate("cube0001", "cubeA", 1, 1);
        cube2 = this.mockCandidate("cube0002", "cubeB", 2, 2);
        Candidate cube3 = this.mockCandidate("cube0003", "cubeC", 4, 4);
        this.sort(cube1, cube2, cube3).assertFirst(cube1);
    }

    private SortedCandidate sort(Candidate ... candidates) {
        return candidate -> Arrays.sort(candidates, Candidate.COMPARATOR);
    }

    private Candidate mockCandidate(String cubeId, String cubeName, int cubeCost, int candidateCost) {
        Candidate candidate = new Candidate();
        candidate.realization = this.mockRealization(cubeId, cubeName, cubeCost);
        CapabilityResult cap = new CapabilityResult();
        cap.setCost(candidateCost);
        candidate.setCapability(cap);
        return candidate;
    }

    private IRealization mockRealization(String cubeId, final String cubeName, final int cost) {
        return new IRealization(){

            public CapabilityResult isCapable(SQLDigest digest) {
                return null;
            }

            public RealizationType getType() {
                return null;
            }

            public KylinConfig getConfig() {
                return null;
            }

            public DataModelDesc getModel() {
                DataModelDesc model = new DataModelDesc();
                model.setName("modelName");
                model.setUuid("model001");
                return model;
            }

            public Set<TblColRef> getAllColumns() {
                return null;
            }

            public Set<ColumnDesc> getAllColumnDescs() {
                return null;
            }

            public List<TblColRef> getAllDimensions() {
                return null;
            }

            public List<MeasureDesc> getMeasures() {
                return null;
            }

            public boolean isReady() {
                return true;
            }

            public String getName() {
                return cubeName;
            }

            public String getCanonicalName() {
                return null;
            }

            public long getDateRangeStart() {
                return 0L;
            }

            public long getDateRangeEnd() {
                return 0L;
            }

            public boolean supportsLimitPushDown() {
                return false;
            }

            public int getCost() {
                return cost;
            }

            public int getStorageType() {
                return 0;
            }
        };
    }

    private static interface SortedCandidate {
        public void assertFirst(Candidate var1);
    }
}

