/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode.visitor;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.visitor.TupleFilterVisitor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TupleFilterVisitorTest
extends LocalFileMetadataTestCase {
    @BeforeClass
    public static void setupResource() {
        TupleFilterVisitorTest.staticCreateTestMetadata((String[])new String[0]);
    }

    @Test
    public void testMergeToInClause1() {
        TupleFilter originFilter = this.getMockFilter1();
        TupleFilter resultFilter = TupleFilterVisitor.mergeToInClause((TupleFilter)originFilter);
        Assert.assertNotNull((Object)resultFilter);
        Assert.assertEquals((long)2L, (long)resultFilter.getChildren().size());
    }

    @Test
    public void testMergeToInClause2() {
        TupleFilter originFilter = this.getMockFilter2();
        TupleFilter resultFilter = TupleFilterVisitor.mergeToInClause((TupleFilter)originFilter);
        Assert.assertNotNull((Object)resultFilter);
        Assert.assertEquals((long)2L, (long)resultFilter.getChildren().size());
    }

    private TupleFilter getMockFilter1() {
        LogicalTupleFilter ret = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
        TblColRef colRef1 = TblColRef.newInnerColumn((String)"DEFAULT.TEST_KYLIN_FACT.LSTG_FORMAT_NAME", (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
        ret.addChildren(new TupleFilter[]{this.getCompareEQFilter(colRef1, "ABIN")});
        ret.addChildren(new TupleFilter[]{this.getCompareEQFilter(colRef1, "Auction")});
        TblColRef colRef2 = TblColRef.newInnerColumn((String)"DEFAULT.TEST_KYLIN_FACT.DEAL_YEAR", (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
        ret.addChildren(new TupleFilter[]{this.getCompareEQFilter(colRef2, "2012")});
        ret.addChildren(new TupleFilter[]{this.getCompareEQFilter(colRef2, "2013")});
        return ret;
    }

    private TupleFilter getMockFilter2() {
        LogicalTupleFilter ret = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
        TblColRef colRef = TblColRef.newInnerColumn((String)"DEFAULT.TEST_KYLIN_FACT.LSTG_FORMAT_NAME", (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
        ret.addChildren(new TupleFilter[]{this.getCompareEQFilter(colRef, "ABIN")});
        ret.addChildren(new TupleFilter[]{this.getCompareEQFilter(colRef, "Auction")});
        CompareTupleFilter notInFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.NOTIN);
        notInFilter.addChildren(new TupleFilter[]{this.getCompareEQFilter(colRef, "Auction", "Others")});
        ret.addChildren(new TupleFilter[]{notInFilter});
        return ret;
    }

    private CompareTupleFilter getCompareEQFilter(TblColRef colRef, String ... values) {
        CompareTupleFilter ret = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
        ret.addChild((TupleFilter)new ColumnTupleFilter(colRef));
        ret.addChild((TupleFilter)new ConstantTupleFilter((Collection)Lists.newArrayList((Object[])values)));
        return ret;
    }
}

