/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.calcite;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.query.calcite.KylinRelDataTypeSystem;
import org.apache.kylin.query.schema.OLAPTable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KylinRelDataTypeSystemTest
extends LocalFileMetadataTestCase {
    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testLegalDecimalType() {
        KylinRelDataTypeSystem typeSystem = new KylinRelDataTypeSystem();
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl((RelDataTypeSystem)typeSystem);
        DataType dataType = DataType.getType((String)"decimal(30, 10)");
        RelDataType relDataType = OLAPTable.createSqlType((RelDataTypeFactory)typeFactory, (DataType)dataType, (boolean)true);
        Assert.assertTrue((boolean)(relDataType instanceof BasicSqlType));
        Assert.assertEquals((Object)relDataType.getSqlTypeName(), (Object)SqlTypeName.DECIMAL);
        Assert.assertEquals((long)relDataType.getPrecision(), (long)30L);
        Assert.assertTrue((relDataType.getPrecision() <= typeSystem.getMaxNumericPrecision() ? 1 : 0) != 0);
        Assert.assertEquals((long)relDataType.getScale(), (long)10L);
        Assert.assertTrue((relDataType.getScale() <= typeSystem.getMaxNumericScale() ? 1 : 0) != 0);
    }

    @Test
    public void testIllegalDecimalType() {
        KylinRelDataTypeSystem typeSystem = new KylinRelDataTypeSystem();
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl((RelDataTypeSystem)typeSystem);
        DataType dataType = DataType.getType((String)"decimal(40, 10)");
        RelDataType relDataType = OLAPTable.createSqlType((RelDataTypeFactory)typeFactory, (DataType)dataType, (boolean)true);
        Assert.assertTrue((boolean)(relDataType instanceof BasicSqlType));
        Assert.assertEquals((Object)relDataType.getSqlTypeName(), (Object)SqlTypeName.DECIMAL);
        Assert.assertTrue((typeSystem.getMaxNumericPrecision() < 40 ? 1 : 0) != 0);
        Assert.assertEquals((long)relDataType.getPrecision(), (long)typeSystem.getMaxNumericPrecision());
        Assert.assertEquals((long)relDataType.getScale(), (long)10L);
        Assert.assertTrue((relDataType.getScale() <= typeSystem.getMaxNumericScale() ? 1 : 0) != 0);
    }
}

