/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableThetaJoin;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPProjectRel;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPNonEquiJoinRel
extends EnumerableThetaJoin
implements OLAPRel {
    private OLAPContext context;
    private ColumnRowType columnRowType;
    private boolean hasSubQuery;
    private boolean isTopJoin;

    public OLAPNonEquiJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, variablesSet, joinType);
        this.rowType = this.getRowType();
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        return this.hasSubQuery;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    protected boolean isParentMerelyPermutation(OLAPRel.OLAPImplementor implementor) {
        if (implementor.getParentNode() instanceof OLAPProjectRel) {
            return ((OLAPProjectRel)implementor.getParentNode()).isMerelyPermutation();
        }
        return false;
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        if (!(implementor.getParentNode() instanceof OLAPJoinRel || implementor.getParentNode() instanceof OLAPNonEquiJoinRel || this.isParentMerelyPermutation(implementor))) {
            implementor.allocateContext();
        }
        this.context = implementor.getContext();
        this.isTopJoin = !this.context.hasJoin;
        this.context.hasJoin = true;
        this.hasSubQuery = true;
        implementor.fixSharedOlapTableScanOnTheLeft((BiRel)this);
        implementor.setNewOLAPContextRequired(true);
        implementor.visitChild(this.left, this);
        if (this.context != implementor.getContext()) {
            implementor.freeContext();
        }
        implementor.fixSharedOlapTableScanOnTheRight((BiRel)this);
        implementor.setNewOLAPContextRequired(true);
        implementor.visitChild(this.right, this);
        if (this.context != implementor.getContext()) {
            implementor.freeContext();
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.isTopJoin) {
            this.context.afterJoin = true;
        }
        this.context.subqueryJoinParticipants.addAll(this.collectJoinColumns(this.condition));
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        Map<TblColRef, RelDataType> dynFields;
        implementor.visitChild(this, this.left);
        implementor.visitChild(this, this.right);
        this.rowType = this.deriveRowType();
        if (this.isTopJoin && !(dynFields = this.context.dynamicFields).isEmpty()) {
            ArrayList newCols = Lists.newArrayList(this.columnRowType.getAllColumns());
            ArrayList newFieldList = Lists.newArrayList();
            int paramIndex = this.rowType.getFieldList().size();
            for (TblColRef fieldCol : dynFields.keySet()) {
                RelDataType fieldType = dynFields.get(fieldCol);
                RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldCol.getName(), paramIndex++, fieldType);
                newFieldList.add(newField);
                newCols.add(fieldCol);
            }
            RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
            fieldInfo.addAll((Iterable)this.rowType.getFieldList());
            fieldInfo.addAll((Iterable)newFieldList);
            this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
            this.columnRowType = new ColumnRowType(newCols);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return super.copy(this.traitSet, this.condition, (RelNode)inputs.get(0), (RelNode)inputs.get(1), this.joinType, this.isSemiJoinDone());
    }

    protected ColumnRowType buildColumnRowType() {
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        OLAPRel olapLeft = (OLAPRel)this.left;
        ColumnRowType leftColumnRowType = olapLeft.getColumnRowType();
        columns.addAll(leftColumnRowType.getAllColumns());
        OLAPRel olapRight = (OLAPRel)this.right;
        ColumnRowType rightColumnRowType = olapRight.getColumnRowType();
        columns.addAll(rightColumnRowType.getAllColumns());
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return super.estimateRowCount(mq) * 0.1;
    }

    public EnumerableThetaJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new OLAPNonEquiJoinRel(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType);
        }
        catch (InvalidRelException var8) {
            throw new AssertionError((Object)var8);
        }
    }

    private Collection<TblColRef> collectJoinColumns(RexNode condition) {
        HashSet joinColumns = Sets.newHashSet();
        this.doCollectJoinColumns(condition, joinColumns);
        return joinColumns;
    }

    private void doCollectJoinColumns(RexNode node, Set<TblColRef> joinColumns) {
        if (node instanceof RexCall) {
            ((RexCall)node).getOperands().forEach(operand -> this.doCollectJoinColumns((RexNode)operand, joinColumns));
        } else if (node instanceof RexInputRef) {
            joinColumns.add(this.columnRowType.getColumnByIndex(((RexInputRef)node).getIndex()));
        }
    }
}

