/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.NoneTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.TblColRef;

public class ColumnRowType {
    private List<TblColRef> columns;
    private List<TupleExpression> sourceColumns;

    public ColumnRowType(List<TblColRef> columns) {
        this(columns, null);
    }

    public ColumnRowType(List<TblColRef> columns, List<TupleExpression> sourceColumns) {
        this.columns = columns;
        this.sourceColumns = sourceColumns;
    }

    public TblColRef getColumnByIndex(int index) {
        return this.columns.get(index);
    }

    public TblColRef getColumnByIndexNullable(int index) {
        if (index < 0 || index >= this.columns.size()) {
            return null;
        }
        return this.columns.get(index);
    }

    public TblColRef getColumnByName(String columnName) {
        return this.getColumnByIndexNullable(this.getIndexByName(columnName));
    }

    public int getIndexByName(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public Pair<TblColRef, TupleExpression> replaceColumnByIndex(int index, TblColRef newColumn, TupleExpression newTupleExpr) {
        if (index < 0 || index >= this.columns.size()) {
            return null;
        }
        TblColRef oldCol = this.columns.set(index, newColumn);
        TupleExpression oldExpr = this.sourceColumns.set(index, newTupleExpr);
        return new Pair((Object)oldCol, (Object)oldExpr);
    }

    public TupleExpression getTupleExpressionByIndex(int i) {
        TupleExpression result = null;
        if (this.sourceColumns != null) {
            result = this.sourceColumns.get(i);
        }
        if (result == null || result instanceof NoneTupleExpression) {
            result = new ColumnTupleExpression(this.getColumnByIndex(i));
        }
        return result;
    }

    public List<TupleExpression> getSourceColumns() {
        if (this.sourceColumns == null) {
            ArrayList<TupleExpression> sources = new ArrayList<TupleExpression>();
            for (int i = 0; i < this.columns.size(); ++i) {
                sources.add(this.getTupleExpressionByIndex(i));
            }
            this.sourceColumns = sources;
        }
        return this.sourceColumns;
    }

    public List<TblColRef> getAllColumns() {
        return this.columns;
    }

    public int size() {
        return this.columns.size();
    }

    public String toString() {
        return "ColumnRowType [" + this.columns + "]";
    }
}

