/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metadata.realization.SQLDigest;

public class Candidate {
    public static final CandidateComparator COMPARATOR = new CandidateComparator();
    static Map<RealizationType, Integer> DEFAULT_PRIORITIES = Maps.newHashMap();
    static Map<RealizationType, Integer> PRIORITIES = DEFAULT_PRIORITIES;
    IRealization realization;
    SQLDigest sqlDigest;
    int priority;
    CapabilityResult capability;

    Candidate() {
    }

    public static void setPriorities(Map<RealizationType, Integer> priorities) {
        PRIORITIES = Collections.unmodifiableMap(priorities);
    }

    public static void restorePriorities() {
        PRIORITIES = Collections.unmodifiableMap(DEFAULT_PRIORITIES);
    }

    public Candidate(IRealization realization, SQLDigest sqlDigest) {
        this.realization = realization;
        this.sqlDigest = sqlDigest;
        this.priority = PRIORITIES.get(realization.getType());
    }

    public IRealization getRealization() {
        return this.realization;
    }

    public SQLDigest getSqlDigest() {
        return this.sqlDigest;
    }

    public int getPriority() {
        return this.priority;
    }

    public CapabilityResult getCapability() {
        return this.capability;
    }

    public void setCapability(CapabilityResult capability) {
        this.capability = capability;
    }

    public String toString() {
        return this.realization.toString();
    }

    static {
        DEFAULT_PRIORITIES.put(RealizationType.HYBRID, 0);
        DEFAULT_PRIORITIES.put(RealizationType.CUBE, 1);
    }

    public static class CandidateComparator
    implements Comparator<Candidate> {
        @Override
        public int compare(Candidate c1, Candidate c2) {
            int comp;
            IRealization real1 = c1.getRealization();
            IRealization real2 = c2.getRealization();
            if (QueryContextFacade.current().getCubePriorities().length > 0) {
                HashMap<String, Integer> priorities = new HashMap<String, Integer>();
                for (int i = 0; i < QueryContextFacade.current().getCubePriorities().length; ++i) {
                    priorities.put(QueryContextFacade.current().getCubePriorities()[i], i);
                }
                int comp2 = priorities.getOrDefault(real1.getName(), Integer.MAX_VALUE) - priorities.getOrDefault(real2.getName(), Integer.MAX_VALUE);
                if (comp2 != 0) {
                    return comp2;
                }
            }
            if ((comp = real1.getCost() - real2.getCost()) != 0) {
                return comp;
            }
            comp = Double.compare(c1.capability.cost, c2.capability.cost);
            if (comp != 0) {
                return comp;
            }
            return 0;
        }
    }
}

