/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.measure.bitmap.BitmapMeasureType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.NoneTupleExpression;
import org.apache.kylin.metadata.expression.NumberTupleExpression;
import org.apache.kylin.metadata.expression.RexCallTupleExpression;
import org.apache.kylin.metadata.expression.StringTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPAggregateRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPFilterRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPToEnumerableConverter;
import org.apache.kylin.query.relnode.visitor.TupleExpressionVisitor;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPProjectRel
extends Project
implements OLAPRel {
    private final BasicSqlType dateType = new BasicSqlType(this.getCluster().getTypeFactory().getTypeSystem(), SqlTypeName.DATE);
    private final BasicSqlType timestampType = new BasicSqlType(this.getCluster().getTypeFactory().getTypeSystem(), SqlTypeName.TIMESTAMP);
    private final ArraySqlType dateArrayType = new ArraySqlType((RelDataType)this.dateType, true);
    private final ArraySqlType timestampArrayType = new ArraySqlType((RelDataType)this.timestampType, true);
    public List<RexNode> rewriteProjects;
    OLAPContext context;
    boolean rewriting;
    ColumnRowType columnRowType;
    boolean hasJoin;
    boolean afterJoin;
    boolean afterAggregate;
    boolean isMerelyPermutation = false;
    private int caseCount = 0;
    private boolean hasIntersect = false;

    public OLAPProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        super(cluster, traitSet, child, exps, rowType);
        Preconditions.checkArgument((this.getConvention() == OLAPRel.CONVENTION ? 1 : 0) != 0);
        Preconditions.checkArgument((child.getConvention() == OLAPRel.CONVENTION ? 1 : 0) != 0);
        this.rewriteProjects = new ArrayList<RexNode>(exps);
        this.hasJoin = false;
        this.afterJoin = false;
        this.rowType = this.getRowType();
        for (RexNode exp : exps) {
            this.caseCount += RelUtils.countOperatorCall((SqlOperator)SqlCaseOperator.INSTANCE, (RexNode)exp);
        }
    }

    public List<RexNode> getChildExps() {
        return this.rewriteProjects;
    }

    public List<RexNode> getProjects() {
        return this.rewriteProjects;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        boolean hasRexOver = RexOver.containsOver(this.getProjects(), null);
        RelOptCost relOptCost = super.computeSelfCost(planner, mq).multiplyBy(0.05).multiplyBy((double)this.getProjects().size() * (double)(hasRexOver ? 50 : 1)).plus(planner.getCostFactory().makeCost(0.1 * (double)this.caseCount, 0.0, 0.0));
        return planner.getCostFactory().makeCost(relOptCost.getRows(), 0.0, 0.0);
    }

    public Project copy(RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        return new OLAPProjectRel(this.getCluster(), traitSet, child, exps, rowType);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        if (this.getPermutation() != null && !(implementor.getParentNode() instanceof OLAPToEnumerableConverter)) {
            this.isMerelyPermutation = true;
        }
        implementor.fixSharedOlapTableScan((SingleRel)this);
        implementor.visitChild(this.getInput(), this);
        this.context = implementor.getContext();
        this.hasJoin = this.context.hasJoin;
        this.afterJoin = this.context.afterJoin;
        this.afterAggregate = this.context.afterAggregate;
        this.columnRowType = this.buildColumnRowType();
        RelNode parentNode = implementor.getParentNode();
        if (parentNode instanceof OLAPAggregateRel) {
            OLAPAggregateRel rel = (OLAPAggregateRel)parentNode;
            for (AggregateCall call : rel.getRewriteAggCalls()) {
                if (!call.getAggregation().getName().equalsIgnoreCase("INTERSECT_COUNT")) continue;
                this.hasIntersect = true;
                logger.trace("Find intersect count in query.");
                break;
            }
        }
    }

    ColumnRowType buildColumnRowType() {
        ArrayList columns = Lists.newArrayList();
        ArrayList sourceColumns = Lists.newArrayList();
        OLAPRel olapChild = (OLAPRel)this.getInput();
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        boolean ifVerify = !this.hasSubQuery() && !this.afterAggregate;
        TupleExpressionVisitor visitor = new TupleExpressionVisitor(inputColumnRowType, ifVerify);
        for (int i = 0; i < this.rewriteProjects.size(); ++i) {
            RexNode rex = this.rewriteProjects.get(i);
            RelDataTypeField columnField = (RelDataTypeField)this.rowType.getFieldList().get(i);
            String fieldName = columnField.getName();
            TupleExpression tupleExpr = (TupleExpression)rex.accept((RexVisitor)visitor);
            TblColRef column = this.translateRexNode(rex, inputColumnRowType, tupleExpr, fieldName);
            if (!(this.rewriting || this.afterAggregate || this.isMerelyPermutation)) {
                Set srcCols = ExpressionColCollector.collectColumns((TupleExpression)tupleExpr);
                Iterator srcColIter = srcCols.iterator();
                while (srcColIter.hasNext()) {
                    if (this.context.belongToContextTables((TblColRef)srcColIter.next())) continue;
                    srcColIter.remove();
                }
                this.context.allColumns.addAll(srcCols);
                if (this.context.isDynamicColumnEnabled() && tupleExpr.ifForDynamicColumn()) {
                    SqlTypeName fSqlType = columnField.getType().getSqlTypeName();
                    String dataType = OLAPTable.DATATYPE_MAPPING.get(fSqlType);
                    if (DataType.isNumberFamily((String)dataType)) {
                        dataType = "decimal";
                    }
                    column.getColumnDesc().setDatatype(dataType);
                    this.context.dynamicFields.put(column, columnField.getType());
                }
            } else {
                tupleExpr = new NoneTupleExpression();
            }
            columns.add(column);
            sourceColumns.add(tupleExpr);
        }
        return new ColumnRowType(columns, sourceColumns);
    }

    private TblColRef translateRexNode(RexNode rexNode, ColumnRowType inputColumnRowType, TupleExpression tupleExpr, String fieldName) {
        RexInputRef inputRef;
        int index;
        if (tupleExpr instanceof ColumnTupleExpression) {
            return ((ColumnTupleExpression)tupleExpr).getColumn();
        }
        if (tupleExpr instanceof NumberTupleExpression) {
            BigDecimal value = ((NumberTupleExpression)tupleExpr).getValue();
            return TblColRef.newInnerColumn((String)(value == null ? "null" : ((Object)value).toString()), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
        }
        if (tupleExpr instanceof StringTupleExpression) {
            String value = ((StringTupleExpression)tupleExpr).getValue();
            return TblColRef.newInnerColumn((String)(value == null ? "null" : value.toString()), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
        }
        if (tupleExpr instanceof RexCallTupleExpression && rexNode instanceof RexInputRef && (index = (inputRef = (RexInputRef)rexNode).getIndex()) < inputColumnRowType.size()) {
            return inputColumnRowType.getColumnByIndex(index);
        }
        return TblColRef.newInnerColumn((String)fieldName, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL, (String)tupleExpr.getDigest());
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        if (this.getInput() instanceof OLAPFilterRel) {
            OLAPFilterRel filter = (OLAPFilterRel)this.getInput();
            RelNode inputOfFilter = inputs.get(0).getInput(0);
            RexProgram program = RexProgram.create((RelDataType)inputOfFilter.getRowType(), this.rewriteProjects, (RexNode)filter.getCondition(), (RelDataType)this.rowType, (RexBuilder)this.getCluster().getRexBuilder());
            return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), inputOfFilter, program);
        }
        EnumerableRel input = (EnumerableRel)OLAPProjectRel.sole(inputs);
        RexProgram program = RexProgram.create((RelDataType)input.getRowType(), this.rewriteProjects, null, (RelDataType)this.rowType, (RexBuilder)this.getCluster().getRexBuilder());
        return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)input, program);
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        this.rewriting = true;
        if (!OLAPRel.RewriteImplementor.needRewrite(this.context) || this.hasJoin && !this.afterJoin || this.afterAggregate || !this.context.hasPrecalculatedFields()) {
            this.columnRowType = this.buildColumnRowType();
            return;
        }
        LinkedList newFieldList = Lists.newLinkedList();
        LinkedList newExpList = Lists.newLinkedList();
        HashMap replaceFieldMap = Maps.newHashMapWithExpectedSize((int)this.context.dynamicFields.size());
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        int paramIndex = this.rowType.getFieldList().size();
        for (Map.Entry<String, RelDataType> rewriteField : this.context.rewriteFields.entrySet()) {
            int inputIndex;
            String string = rewriteField.getKey();
            int rowIndex = this.columnRowType.getIndexByName(string);
            if (rowIndex >= 0 || (inputIndex = inputColumnRowType.getIndexByName(string)) < 0) continue;
            RelDataType fieldType = (RelDataType)rewriteField.getValue();
            RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(string, paramIndex++, fieldType);
            newFieldList.add(newField);
            RelDataTypeField inputField = (RelDataTypeField)this.getInput().getRowType().getFieldList().get(inputIndex);
            RexInputRef newFieldRef = new RexInputRef(inputField.getIndex(), inputField.getType());
            newExpList.add(newFieldRef);
        }
        if (this.context.afterAggregate) {
            Map<TblColRef, RelDataType> dynFields = this.context.dynamicFields;
            for (TblColRef tblColRef : dynFields.keySet()) {
                int inputIndex;
                String replaceFieldName = tblColRef.getName();
                int rowIndex = this.columnRowType.getIndexByName(replaceFieldName);
                if (rowIndex < 0 || (inputIndex = inputColumnRowType.getIndexByName(replaceFieldName)) < 0) continue;
                RelDataType fieldType = dynFields.get(tblColRef);
                RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(replaceFieldName, rowIndex, fieldType);
                RelDataTypeField inputField = (RelDataTypeField)this.getInput().getRowType().getFieldList().get(inputIndex);
                RexInputRef newFieldRef = new RexInputRef(inputField.getIndex(), inputField.getType());
                replaceFieldMap.put(rowIndex, new Pair((Object)newField, (Object)newFieldRef));
            }
        }
        if (!newFieldList.isEmpty() || !replaceFieldMap.isEmpty()) {
            ArrayList newProjects = Lists.newArrayList(this.rewriteProjects);
            ArrayList newFields = Lists.newArrayList((Iterable)this.rowType.getFieldList());
            Iterator iterator = replaceFieldMap.keySet().iterator();
            while (iterator.hasNext()) {
                int rowIndex = (Integer)iterator.next();
                Pair entry = (Pair)replaceFieldMap.get(rowIndex);
                newProjects.set(rowIndex, entry.getSecond());
                newFields.set(rowIndex, entry.getFirst());
            }
            newProjects.addAll(newExpList);
            this.rewriteProjects = newProjects;
            RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = this.getCluster().getTypeFactory().builder();
            fieldInfoBuilder.addAll((Iterable)newFields);
            fieldInfoBuilder.addAll((Iterable)newFieldList);
            this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfoBuilder);
        }
        this.columnRowType = this.buildColumnRowType();
        this.rewriteProjectsForArrayDataType();
        this.rewriting = false;
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public boolean isMerelyPermutation() {
        return this.isMerelyPermutation;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization));
    }

    private void rewriteProjectsForArrayDataType() {
        if (this.hasIntersect) {
            HashSet<TblColRef> tblColRefs = new HashSet<TblColRef>(this.context.allColumns);
            IRealization realization = this.context.realization;
            TblColRef groupBy = null;
            DataType groupByType = null;
            if (realization instanceof CubeInstance) {
                CubeDesc cubeDesc = ((CubeInstance)realization).getDescriptor();
                for (MeasureDesc measureDesc : cubeDesc.getMeasures()) {
                    if (!(measureDesc.getFunction().getMeasureType() instanceof BitmapMeasureType)) continue;
                    TblColRef col1 = measureDesc.getFunction().getParameter().getColRef();
                    tblColRefs.remove(col1);
                    logger.trace("Remove {}", (Object)col1);
                }
                if (tblColRefs.size() == 1) {
                    Iterator iterator = tblColRefs.iterator();
                    while (iterator.hasNext()) {
                        TblColRef colRef;
                        groupBy = colRef = (TblColRef)iterator.next();
                        groupByType = groupBy.getType();
                        logger.trace("Group By Column in intersect_count should be {}.", (Object)groupBy);
                    }
                    if (groupByType != null && groupByType.isDateTimeFamily()) {
                        for (int i = 0; i < this.rewriteProjects.size(); ++i) {
                            RexNode rex = this.rewriteProjects.get(i);
                            if (groupByType.isTimestamp()) {
                                this.rewriteProjectForIntersect(rex, SqlTypeName.TIMESTAMP, this.timestampType, this.timestampArrayType, i);
                                continue;
                            }
                            if (!groupByType.isDate()) continue;
                            this.rewriteProjectForIntersect(rex, SqlTypeName.DATE, this.dateType, this.dateArrayType, i);
                        }
                    }
                } else {
                    logger.trace("After remove, {}.", (Object)tblColRefs.size());
                }
            }
        }
    }

    private void rewriteProjectForIntersect(RexNode rex, SqlTypeName sqlTypeName, BasicSqlType eleSqlType, ArraySqlType arraySqlType, int idx) {
        if (rex.isA(SqlKind.ARRAY_VALUE_CONSTRUCTOR)) {
            List nodeList = ((RexCall)rex).getOperands();
            RexLiteral newNode = null;
            boolean needChange = true;
            ArrayList<RexLiteral> newerList = new ArrayList<RexLiteral>();
            if (!nodeList.isEmpty()) {
                for (RexNode node : nodeList) {
                    if (node instanceof RexLiteral) {
                        RexLiteral literal = (RexLiteral)node;
                        if (literal.getTypeName() == sqlTypeName) {
                            needChange = false;
                            break;
                        }
                        newNode = RexLiteral.fromJdbcString((RelDataType)eleSqlType, (SqlTypeName)sqlTypeName, (String)literal.getValue2().toString());
                    }
                    if (newNode != null) {
                        newerList.add(newNode);
                    }
                    newNode = null;
                }
                if (needChange) {
                    this.rewriteProjects.set(idx, (RexNode)((RexCall)rex).clone((RelDataType)arraySqlType, newerList));
                    logger.debug("Rewrite project REL {} for intersect count.", (Object)this.rewriteProjects.get(idx));
                }
            }
        }
    }
}

