/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinsTree;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPAuthentication;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.routing.RealizationCheck;
import org.apache.kylin.query.schema.OLAPSchema;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.hybrid.HybridInstance;

public class OLAPContext {
    public static final String PRM_ACCEPT_PARTIAL_RESULT = "AcceptPartialResult";
    public static final String PRM_USER_AUTHEN_INFO = "UserAuthenInfo";
    static final InternalThreadLocal<Map<String, String>> _localPrarameters = new InternalThreadLocal();
    static final InternalThreadLocal<Map<Integer, OLAPContext>> _localContexts = new InternalThreadLocal();
    public final int id;
    public final StorageContext storageContext;
    public OLAPSchema olapSchema = null;
    public OLAPTableScan firstTableScan = null;
    public Set<OLAPTableScan> allTableScans = new HashSet<OLAPTableScan>();
    public Set<OLAPJoinRel> allOlapJoins = new HashSet<OLAPJoinRel>();
    public Set<MeasureDesc> involvedMeasure = new HashSet<MeasureDesc>();
    public TupleInfo returnTupleInfo = null;
    public boolean afterAggregate = false;
    public boolean afterHavingClauseFilter = false;
    public boolean afterLimit = false;
    public boolean limitPrecedesAggr = false;
    public boolean afterJoin = false;
    public boolean hasJoin = false;
    public boolean hasLimit = false;
    public boolean hasWindow = false;
    public boolean groupByExpression = false;
    public boolean afterOuterAggregate = false;
    public boolean disableLimitPushdown = !KylinConfig.getInstanceFromEnv().isLimitPushDownEnabled();
    public boolean isExactlyAggregate = false;
    public IRealization realization;
    public RealizationCheck realizationCheck;
    public boolean fixedModel;
    public Set<TblColRef> allColumns = new HashSet<TblColRef>();
    public List<TblColRef> groupByColumns = new ArrayList<TblColRef>();
    public Set<TblColRef> subqueryJoinParticipants = new HashSet<TblColRef>();
    public Set<TblColRef> metricsColumns = new HashSet<TblColRef>();
    public List<FunctionDesc> aggregations = new ArrayList<FunctionDesc>();
    public List<TblColRef> aggrOutCols = new ArrayList<TblColRef>();
    public List<SQLDigest.SQLCall> aggrSqlCalls = new ArrayList<SQLDigest.SQLCall>();
    public Set<TblColRef> filterColumns = new HashSet<TblColRef>();
    public TupleFilter filter;
    public TupleFilter havingFilter;
    public List<JoinDesc> joins = new LinkedList<JoinDesc>();
    public JoinsTree joinsTree;
    public boolean isBorrowedContext = false;
    List<TblColRef> sortColumns;
    List<SQLDigest.OrderEnum> sortOrders;
    public Map<String, RelDataType> rewriteFields = new HashMap<String, RelDataType>();
    public Map<TblColRef, RelDataType> dynamicFields = new HashMap<TblColRef, RelDataType>();
    public Map<TblColRef, TupleExpression> dynGroupBy = new HashMap<TblColRef, TupleExpression>();
    public String sql = "";
    public OLAPAuthentication olapAuthen = new OLAPAuthentication();
    SQLDigest sqlDigest;

    public static void setParameters(Map<String, String> parameters) {
        _localPrarameters.set(parameters);
    }

    public static void clearParameter() {
        _localPrarameters.remove();
    }

    public static void registerContext(OLAPContext ctx) {
        if (_localContexts.get() == null) {
            HashMap contextMap = new HashMap();
            _localContexts.set(contextMap);
        }
        ((Map)_localContexts.get()).put(ctx.id, ctx);
    }

    public static Collection<OLAPContext> getThreadLocalContexts() {
        Map map = (Map)_localContexts.get();
        return map == null ? null : map.values();
    }

    public static OLAPContext getThreadLocalContextById(int id) {
        Map map = (Map)_localContexts.get();
        return (OLAPContext)map.get(id);
    }

    public static void clearThreadLocalContexts() {
        _localContexts.remove();
    }

    public OLAPContext(int seq) {
        this.id = seq;
        this.storageContext = new StorageContext(seq);
        this.sortColumns = Lists.newArrayList();
        this.sortOrders = Lists.newArrayList();
        Map parameters = (Map)_localPrarameters.get();
        if (parameters != null) {
            String acceptUserInfo;
            String acceptPartialResult = (String)parameters.get(PRM_ACCEPT_PARTIAL_RESULT);
            if (acceptPartialResult != null) {
                this.storageContext.setAcceptPartialResult(Boolean.parseBoolean(acceptPartialResult));
            }
            if (null != (acceptUserInfo = (String)parameters.get(PRM_USER_AUTHEN_INFO))) {
                this.olapAuthen.parseUserInfo(acceptUserInfo);
            }
        }
    }

    public boolean isSimpleQuery() {
        return this.joins.isEmpty() && this.groupByColumns.isEmpty() && this.aggregations.isEmpty();
    }

    public SQLDigest getSQLDigest() {
        if (this.sqlDigest == null) {
            HashSet rtDimColumns = new HashSet();
            for (TupleExpression tupleExpr : this.dynGroupBy.values()) {
                rtDimColumns.addAll(ExpressionColCollector.collectColumns((TupleExpression)tupleExpr));
            }
            HashSet rtMetricColumns = new HashSet();
            LinkedList dynFuncs = Lists.newLinkedList();
            for (FunctionDesc functionDesc : this.aggregations) {
                if (!(functionDesc instanceof DynamicFunctionDesc)) continue;
                DynamicFunctionDesc dynFunc = (DynamicFunctionDesc)functionDesc;
                rtMetricColumns.addAll(dynFunc.getMeasureColumnSet());
                rtDimColumns.addAll(dynFunc.getFilterColumnSet());
                dynFuncs.add(dynFunc);
            }
            this.sqlDigest = new SQLDigest(this.firstTableScan.getTableName(), this.allColumns, this.joins, this.groupByColumns, this.subqueryJoinParticipants, this.dynGroupBy, this.groupByExpression, this.metricsColumns, this.aggregations, this.aggrSqlCalls, (List)dynFuncs, rtDimColumns, rtMetricColumns, this.filterColumns, this.filter, this.havingFilter, this.sortColumns, this.sortOrders, this.limitPrecedesAggr, this.hasLimit, this.isBorrowedContext, this.involvedMeasure);
        }
        return this.sqlDigest;
    }

    public boolean isDynamicColumnEnabled() {
        return this.olapSchema != null && this.olapSchema.getProjectInstance().getConfig().isDynamicColumnEnabled();
    }

    public boolean hasPrecalculatedFields() {
        return this.realization instanceof CubeInstance || this.realization instanceof HybridInstance;
    }

    public void resetSQLDigest() {
        this.sqlDigest = null;
    }

    public boolean belongToContextTables(TblColRef tblColRef) {
        for (OLAPTableScan olapTableScan : this.allTableScans) {
            if (!olapTableScan.getColumnRowType().getAllColumns().contains(tblColRef)) continue;
            return true;
        }
        return false;
    }

    public boolean belongToFactTableDims(TblColRef tblColRef) {
        if (!this.belongToContextTables(tblColRef)) {
            return false;
        }
        KylinConfig kylinConfig = this.olapSchema.getConfig();
        String projectName = this.olapSchema.getProjectName();
        String factTableName = this.firstTableScan.getOlapTable().getTableName();
        Set realizations = ProjectManager.getInstance((KylinConfig)kylinConfig).getRealizationsByTable(projectName, factTableName);
        for (IRealization real : realizations) {
            DataModelDesc model = real.getModel();
            TblColRef.fixUnknownModel((DataModelDesc)model, (String)tblColRef.getTableRef().getTableIdentity(), (TblColRef)tblColRef);
            HashSet metrics = Sets.newHashSet((Object[])model.getMetrics());
            if (metrics.contains(tblColRef.getIdentity())) {
                tblColRef.unfixTableRef();
                return false;
            }
            for (TableRef factTable : model.getFactTables()) {
                if (!factTable.getColumns().contains(tblColRef)) continue;
                tblColRef.unfixTableRef();
                return true;
            }
            tblColRef.unfixTableRef();
        }
        return false;
    }

    public void setReturnTupleInfo(RelDataType rowType, ColumnRowType columnRowType) {
        TupleInfo info = new TupleInfo();
        List fieldList = rowType.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            RelDataTypeField field = (RelDataTypeField)fieldList.get(i);
            TblColRef col = columnRowType == null ? null : columnRowType.getColumnByIndex(i);
            info.setField(field.getName(), col, i);
        }
        this.returnTupleInfo = info;
    }

    public void addSort(TblColRef col, SQLDigest.OrderEnum order) {
        if (col != null) {
            this.sortColumns.add(col);
            this.sortOrders.add(order);
        }
    }

    public void fixModel(DataModelDesc model, Map<String, String> aliasMap) {
        if (this.fixedModel) {
            return;
        }
        for (OLAPTableScan tableScan : this.allTableScans) {
            tableScan.fixColumnRowTypeWithModel(model, aliasMap);
        }
        this.fixedModel = true;
    }

    public void unfixModel() {
        if (!this.fixedModel) {
            return;
        }
        for (OLAPTableScan tableScan : this.allTableScans) {
            tableScan.unfixColumnRowTypeWithModel();
        }
        this.fixedModel = false;
    }

    public void bindVariable(DataContext dataContext) {
        this.bindVariable(this.filter, dataContext);
    }

    private void bindVariable(TupleFilter filter, DataContext dataContext) {
        if (filter == null) {
            return;
        }
        for (TupleFilter childFilter : filter.getChildren()) {
            this.bindVariable(childFilter, dataContext);
        }
        if (filter instanceof CompareTupleFilter && dataContext != null) {
            CompareTupleFilter compFilter = (CompareTupleFilter)filter;
            for (Map.Entry entry : compFilter.getVariables().entrySet()) {
                String variable = (String)entry.getKey();
                Object value = dataContext.get(variable);
                if (value == null) continue;
                String str = value.toString();
                str = this.transferDateTimeColumnToMillis(compFilter, str);
                compFilter.clearPreviousVariableValues(variable);
                compFilter.bindVariable(variable, (Object)str);
            }
        }
    }

    private String transferDateTimeColumnToMillis(CompareTupleFilter compFilter, String value) {
        TblColRef column = compFilter.getColumn();
        if (Objects.isNull(column)) {
            return value;
        }
        if (column.getType().isDateTimeFamily()) {
            value = String.valueOf(DateFormat.stringToMillis((String)value));
        }
        return value;
    }

    public static interface IAccessController {
        public void check(List<OLAPContext> var1, KylinConfig var2);
    }
}

