/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.routing.RealizationCheck;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RealizationCheckTest
extends LocalFileMetadataTestCase {
    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testRealizationCheck() {
        RealizationCheck realizationCheck = new RealizationCheck();
        CubeDesc cubeDesc = CubeDescManager.getInstance((KylinConfig)RealizationCheckTest.getTestConfig()).getCubeDesc("ssb");
        DataModelDesc dataModelDesc = cubeDesc.getModel();
        CubeInstance iRealization = CubeInstance.create((String)"ssb", (CubeDesc)cubeDesc);
        realizationCheck.addCubeIncapableReason((IRealization)iRealization, RealizationCheck.IncapableReason.create((RealizationCheck.IncapableType)RealizationCheck.IncapableType.CUBE_NOT_CONTAIN_ALL_COLUMN));
        realizationCheck.addCubeIncapableReason((IRealization)iRealization, RealizationCheck.IncapableReason.create((RealizationCheck.IncapableType)RealizationCheck.IncapableType.CUBE_NOT_CONTAIN_ALL_COLUMN));
        Assert.assertTrue((realizationCheck.getCubeIncapableReasons().size() == 1 ? 1 : 0) != 0);
        realizationCheck.addModelIncapableReason(dataModelDesc, RealizationCheck.IncapableReason.create((RealizationCheck.IncapableType)RealizationCheck.IncapableType.CUBE_NOT_CONTAIN_ALL_COLUMN));
        realizationCheck.addModelIncapableReason(dataModelDesc, RealizationCheck.IncapableReason.create((RealizationCheck.IncapableType)RealizationCheck.IncapableType.CUBE_NOT_CONTAIN_ALL_MEASURE));
        realizationCheck.addModelIncapableReason(dataModelDesc, RealizationCheck.IncapableReason.notContainAllColumn((Collection)Lists.newArrayList()));
        realizationCheck.addModelIncapableReason(dataModelDesc, RealizationCheck.IncapableReason.notContainAllColumn((Collection)Lists.newArrayList()));
        Assert.assertTrue((realizationCheck.getModelIncapableReasons().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((List)realizationCheck.getModelIncapableReasons().get(dataModelDesc)).size() == 3 ? 1 : 0) != 0);
        realizationCheck.addModelIncapableReason(dataModelDesc, RealizationCheck.IncapableReason.notContainAllColumn((Collection)Lists.newArrayList((Object[])new TblColRef[]{dataModelDesc.findColumn("LO_DATE")})));
        Assert.assertTrue((realizationCheck.getModelIncapableReasons().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((List)realizationCheck.getModelIncapableReasons().get(dataModelDesc)).size() == 4 ? 1 : 0) != 0);
    }
}

