/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.query.util.QueryUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryUtilTest
extends LocalFileMetadataTestCase {
    static final String catalog = "CATALOG";

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testappendLimitOffsetToSql() {
        String sql = "select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        String newsql = QueryUtil.appendLimitOffsetToSql((String)sql, (int)100, (int)100);
        Assert.assertEquals((Object)"select * from (select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact) limit 100 offset 100", (Object)newsql);
        sql = "select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        newsql = QueryUtil.appendLimitOffsetToSql((String)sql, (int)0, (int)0);
        Assert.assertEquals((Object)"select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact", (Object)newsql);
        sql = "explain plan for select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        newsql = QueryUtil.appendLimitOffsetToSql((String)sql, (int)100, (int)100);
        Assert.assertEquals((Object)"explain plan for select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact limit 100 offset 100", (Object)newsql);
        sql = "explain plan for select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        newsql = QueryUtil.appendLimitOffsetToSql((String)sql, (int)0, (int)0);
        Assert.assertEquals((Object)"explain plan for select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact", (Object)newsql);
    }

    @Test
    public void testMassageSql() {
        String sql = "select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        String s = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select ( date '2001-09-28' + interval '1' day) from test_kylin_fact", (Object)s);
        sql = "select ( date '2001-09-28' + interval floor(2) month) from test_kylin_fact group by ( date '2001-09-28' + interval floor(2) month)";
        s = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select ( date '2001-09-28' + interval '2' month) from test_kylin_fact group by ( date '2001-09-28' + interval '2' month)", (Object)s);
        sql = "select count(*) test_limit from test_kylin_fact where price > 10.0";
        s = QueryUtil.massageSql((String)sql, (String)"default", (int)50000, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select * from (select count(*) test_limit from test_kylin_fact where price > 10.0) limit 50000", (Object)s);
        sql = "select count(*) test_offset from test_kylin_fact where price > 10.0";
        s = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)50, (String)"DEFAULT");
        Assert.assertEquals((Object)"select * from (select count(*) test_offset from test_kylin_fact where price > 10.0) offset 50", (Object)s);
        sql = "select count(*) test_limit_and_offset from test_kylin_fact where price > 10.0";
        s = QueryUtil.massageSql((String)sql, (String)"default", (int)50000, (int)50, (String)"DEFAULT");
        Assert.assertEquals((Object)"select * from (select count(*) test_limit_and_offset from test_kylin_fact where price > 10.0) limit 50000 offset 50", (Object)s);
        String newLine = System.getProperty("line.separator");
        String sql2 = "select count(*)     test_limit from " + newLine + "test_kylin_fact where price > 10.0";
        newLine = newLine.replace("\r", " ").replace("\n", newLine);
        String s2 = QueryUtil.massageSql((String)sql2, (String)"default", (int)50000, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)("select * from (select count(*)     test_limit from " + newLine + "test_kylin_fact where price > 10.0) limit 50000"), (Object)s2);
        newLine = System.getProperty("line.separator");
        sql2 = "select count(*)     test_offset from " + newLine + "test_kylin_fact where price > 10.0";
        newLine = newLine.replace("\r", " ").replace("\n", newLine);
        s2 = QueryUtil.massageSql((String)sql2, (String)"default", (int)50000, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)("select * from (select count(*)     test_offset from " + newLine + "test_kylin_fact where price > 10.0) limit 50000"), (Object)s2);
        newLine = System.getProperty("line.separator");
        sql2 = "select count(*)     test_limit_and_offset from " + newLine + "test_kylin_fact where price > 10.0";
        newLine = newLine.replace("\r", " ").replace("\n", newLine);
        s2 = QueryUtil.massageSql((String)sql2, (String)"default", (int)50000, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)("select * from (select count(*)     test_limit_and_offset from " + newLine + "test_kylin_fact where price > 10.0) limit 50000"), (Object)s2);
    }

    @Test
    public void testIsSelect() {
        String sql = "select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        boolean selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
        sql = " Select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
        sql = " \nSelect ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
        sql = "--comment\n /* comment */Select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
        sql = " UPDATE Customers\nSET ContactName = 'Alfred Schmidt', City= 'Frankfurt'\nWHERE CustomerID = 1;";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)false, (Object)selectStatement);
        sql = " explain plan for select count(*) from test_kylin_fact\n";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
    }

    @Test
    public void testKeywordDefaultDirtyHack() {
        KylinConfig.getInstanceFromEnv().setProperty("kylin.query.escape-default-keyword", "true");
        String sql = "select * from DEFAULT.TEST_KYLIN_FACT";
        String s = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select * from \"DEFAULT\".TEST_KYLIN_FACT", (Object)s);
    }

    @Test
    public void testForceLimit() {
        KylinConfig.getInstanceFromEnv().setProperty("kylin.query.force-limit", "10");
        String sql1 = "select   * \nfrom DEFAULT.TEST_KYLIN_FACT";
        String result = QueryUtil.massageSql((String)sql1, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select * from (select   * \nfrom DEFAULT.TEST_KYLIN_FACT) limit 10", (Object)result);
        String sql2 = "select   2 * 8 from DEFAULT.TEST_KYLIN_FACT";
        result = QueryUtil.massageSql((String)sql2, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select   2 * 8 from DEFAULT.TEST_KYLIN_FACT", (Object)result);
    }

    @Test
    public void testRemoveCommentInSql() {
        String originSql = "select count(*) from test_kylin_fact where price > 10.0";
        String originSql2 = "select count(*) from test_kylin_fact where TEST_COLUMN != 'not--a comment'";
        String sqlWithComment = "-- comment \n" + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "-- comment \n -- comment\n" + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "-- \n -- comment \n" + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = originSql + "-- \n -- comment \n";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "-- \n -- comment \n" + originSql + "-- \n -- comment \n";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment */ " + originSql + "-- \n -- comment \n";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1/comment2 */ " + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1 * comment2 */ " + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1 * comment2 */ /* comment3 / comment4 */ -- comment 5\n" + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1 * \ncomment2 */ -- comment 5\n" + originSql + "/* comment3 / comment4 */";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1 * \ncomment2 */ -- comment 3\n" + originSql + "-- comment 5\n";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        String sqlWithComment2 = "/* comment1 * \ncomment2 */ -- comment 5\n" + originSql2 + "/* comment3 / comment4 */";
        Assert.assertEquals((Object)originSql2, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment2));
        sqlWithComment2 = "/* comment1 * comment2 */ /* comment3 / comment4 */ -- comment 5\n" + originSql2;
        Assert.assertEquals((Object)originSql2, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment2));
        sqlWithComment2 = "/* comment1 * comment2 */ " + originSql2;
        Assert.assertEquals((Object)originSql2, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment2));
        sqlWithComment2 = "/* comment1/comment2 */ " + originSql2;
        Assert.assertEquals((Object)originSql2, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment2));
        sqlWithComment2 = "-- \n -- comment \n" + originSql2;
        Assert.assertEquals((Object)originSql2, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment2));
        sqlWithComment2 = "-- comment \n" + originSql2;
        Assert.assertEquals((Object)originSql2, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment2));
        sqlWithComment2 = "-- comment \n -- comment\n" + originSql2;
        Assert.assertEquals((Object)originSql2, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment2));
        String content = "        --  One-line comment and /**range\n/*\nMulti-line comment\r\n--  Multi-line comment*/\nselect price as /*\nMulti-line comment\r\n--  Multi-line comment*/\nrevenue from /*One-line comment-- One-line comment*/ v_lineitem;";
        String expectedContent = "select price as revenue from  v_lineitem;";
        String trimmedContent = QueryUtil.removeCommentInSql((String)content).replaceAll("\n", "").trim();
        Assert.assertEquals((Object)trimmedContent, (Object)expectedContent);
    }

    @Test
    public void testUnknownErrorResponseMessage() {
        String msg = QueryUtil.makeErrorMsgUserFriendly((Throwable)new NullPointerException());
        Assert.assertEquals((Object)"Unknown error.", (Object)msg);
    }

    @Test
    public void testRemoveCatalog() {
        String[] beforeRemoveSql = new String[]{"select name, count(*) as cnt from schema1.user where bb.dd >2 group by name", "select name, count(*) as cnt from .default2.user where dd >2 group by name", "select name, count(*) as cnt from %s.default2.user where dd >2 group by name", "select name, count(*) as cnt from %s.user.a.cu where dd >2 group by name", "select name, count(*) as cnt from %s.default2.user where dd >2 group by name", "select name, count() as cnt from %s.test.kylin_sales inner join %s.test.kylin_account ON kylin_sales.BUYER_ID=kylin_account.ACCOUNT_ID group by name", "select schema1.table1.col1 from %s.schema1.table1"};
        String[] afterRemoveSql = new String[]{"select name, count(*) as cnt from schema1.user where bb.dd >2 group by name", "select name, count(*) as cnt from .default2.user where dd >2 group by name", "select name, count(*) as cnt from default2.user where dd >2 group by name", "select name, count(*) as cnt from user.a.cu where dd >2 group by name", "select name, count(*) as cnt from default2.user where dd >2 group by name", "select name, count() as cnt from test.kylin_sales inner join test.kylin_account ON kylin_sales.BUYER_ID=kylin_account.ACCOUNT_ID group by name", "select schema1.table1.col1 from schema1.table1"};
        Assert.assertEquals((long)afterRemoveSql.length, (long)beforeRemoveSql.length);
        for (int i = 0; i < beforeRemoveSql.length; ++i) {
            String before = beforeRemoveSql[i];
            before = before.replace("%s", catalog);
            String after = afterRemoveSql[i];
            Assert.assertEquals((Object)after, (Object)QueryUtil.removeCatalog((String)before, (String)catalog));
        }
    }

    @Test
    public void testLimitAndOffset() {
        String sql = "select e_name from employees_china union select e_name from employees_usa";
        String result1 = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)result1, (Object)"select e_name from employees_china union select e_name from employees_usa");
        String result2 = QueryUtil.massageSql((String)sql, (String)"default", (int)10, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)result2, (Object)"select * from (select e_name from employees_china union select e_name from employees_usa) limit 10");
        String result3 = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)5, (String)"DEFAULT");
        Assert.assertEquals((Object)result3, (Object)"select * from (select e_name from employees_china union select e_name from employees_usa) offset 5");
        String result4 = QueryUtil.massageSql((String)sql, (String)"default", (int)10, (int)5, (String)"DEFAULT");
        Assert.assertEquals((Object)result4, (Object)"select * from (select e_name from employees_china union select e_name from employees_usa) limit 10 offset 5");
    }
}

