/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtil {
    protected static final Logger logger = LoggerFactory.getLogger(QueryUtil.class);
    private static final String KEYWORD_SELECT = "select";
    private static final String KEYWORD_WITH = "with";
    private static final String KEYWORD_EXPLAIN = "explain";
    private static List<IQueryTransformer> queryTransformers;

    private QueryUtil() {
        throw new IllegalStateException("Class QueryUtil is an utility class !");
    }

    public static String appendLimitOffsetToSql(String sql, int limit, int offset) {
        String retSql = sql;
        String prefixSql = "select * from (";
        String suffixSql = ")";
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)KEYWORD_EXPLAIN) || StringUtils.startsWithIgnoreCase((String)sql, (String)KEYWORD_WITH)) {
            prefixSql = "";
            suffixSql = "";
        }
        if (0 != limit && 0 != offset) {
            retSql = prefixSql + sql + suffixSql + " limit " + String.valueOf(limit) + " offset " + String.valueOf(offset);
        } else if (0 == limit && 0 != offset) {
            retSql = prefixSql + sql + suffixSql + " offset " + String.valueOf(offset);
        } else if (0 != limit && 0 == offset) {
            retSql = prefixSql + sql + suffixSql + " limit " + String.valueOf(limit);
        }
        return retSql;
    }

    @Deprecated
    public static String massageSql(String sql, String project, int limit, int offset, String defaultSchema) {
        sql = sql.trim();
        sql = sql.replace("\r", " ").replace("\n", System.getProperty("line.separator"));
        ProjectManager projectManager = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance projectInstance = projectManager.getProject(project);
        KylinConfig kylinConfig = projectInstance.getConfig();
        sql = QueryUtil.removeCommentInSql(sql);
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        String sql1 = sql;
        String suffixPattern = "^.+?\\s(limit\\s\\d+)?\\s(offset\\s\\d+)?\\s*$";
        sql = sql.replaceAll("\\s+", " ");
        Pattern pattern = Pattern.compile("^.+?\\s(limit\\s\\d+)?\\s(offset\\s\\d+)?\\s*$");
        Matcher matcher = pattern.matcher(sql.toLowerCase(Locale.ROOT) + "  ");
        int toAppendLimit = 0;
        int toAppendOffset = 0;
        if (matcher.find()) {
            if (limit > 0 && matcher.group(1) == null) {
                toAppendLimit = limit;
            }
            if (offset > 0 && matcher.group(2) == null) {
                toAppendOffset = offset;
            }
        }
        if (kylinConfig.getForceLimit() > 0 && limit <= 0 && matcher.group(1) == null && sql1.toLowerCase(Locale.ROOT).matches("^select\\s+\\*\\p{all}*")) {
            toAppendLimit = kylinConfig.getForceLimit();
        }
        sql1 = QueryUtil.appendLimitOffsetToSql(sql1, toAppendLimit, toAppendOffset);
        if (queryTransformers == null) {
            QueryUtil.initQueryTransformers();
        }
        for (IQueryTransformer t : queryTransformers) {
            sql1 = t.transform(sql1, project, defaultSchema);
        }
        return sql1;
    }

    public static String massageSql(String sql, String project, int limit, int offset, String defaultSchema, String catalog) {
        String correctedSql = QueryUtil.massageSql(sql, project, limit, offset, defaultSchema);
        correctedSql = QueryUtil.removeCatalog(correctedSql, catalog);
        return correctedSql;
    }

    static String removeCatalog(String sql, String catalog) {
        if (catalog == null) {
            return sql;
        }
        return sql.replace(catalog + ".", "");
    }

    private static void initQueryTransformers() {
        String[] classes;
        ArrayList transformers = Lists.newArrayList();
        for (String clz : classes = KylinConfig.getInstanceFromEnv().getQueryTransformers()) {
            try {
                IQueryTransformer t = (IQueryTransformer)ClassUtil.newInstance((String)clz);
                transformers.add(t);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to init query transformer", e);
            }
        }
        queryTransformers = transformers;
    }

    public static String makeErrorMsgUserFriendly(Throwable e) {
        String msg = e.getMessage();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (cause.getClass().getName().contains("ParseException")) {
                msg = cause.getMessage();
                break;
            }
            if (cause.getClass().getName().contains("ArithmeticException")) {
                msg = "ArithmeticException: " + cause.getMessage();
                break;
            }
            if (!cause.getClass().getName().contains("NumberFormatException")) continue;
            msg = "NumberFormatException: " + cause.getMessage();
            break;
        }
        return QueryUtil.makeErrorMsgUserFriendly(msg);
    }

    public static String makeErrorMsgUserFriendly(String errorMsg) {
        if (errorMsg == null) {
            return "Unknown error.";
        }
        try {
            errorMsg = errorMsg.replaceAll("\\s", " ");
            Pattern pattern = Pattern.compile("Error while executing SQL \"(.*)\":(.*)");
            Matcher matcher = pattern.matcher(errorMsg);
            if (matcher.find()) {
                return matcher.group(2).trim() + "\nwhile executing SQL: \"" + matcher.group(1).trim() + "\"";
            }
            return errorMsg;
        }
        catch (Exception e) {
            return errorMsg;
        }
    }

    public static boolean isSelectStatement(String sql) {
        String sql1 = sql.toLowerCase(Locale.ROOT);
        sql1 = QueryUtil.removeCommentInSql(sql1);
        return (sql1 = sql1.trim()).startsWith(KEYWORD_SELECT) || sql1.startsWith(KEYWORD_WITH) && sql1.contains(KEYWORD_SELECT) || sql1.startsWith(KEYWORD_EXPLAIN) && sql1.contains(KEYWORD_SELECT);
    }

    public static String removeCommentInSql(String sql1) {
        String[] commentPatterns = new String[]{"--(?!.*\\*/).*?[\r\n]", "/\\*(.|\r|\n)*?\\*/"};
        for (int i = 0; i < commentPatterns.length; ++i) {
            sql1 = sql1.replaceAll(commentPatterns[i], "");
        }
        sql1 = sql1.trim();
        return sql1;
    }

    public static interface IQueryTransformer {
        public String transform(String var1, String var2, String var3);
    }
}

