/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode.visitor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.ExtractTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.UnsupportedTupleFilter;
import org.apache.kylin.metadata.filter.function.Functions;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleFilterVisitor
extends RexVisitorImpl<TupleFilter> {
    private static Logger logger = LoggerFactory.getLogger(TupleFilterVisitor.class);
    final ColumnRowType inputRowType;
    private boolean autoJustByTimezone = false;
    private static final long TIME_ZONE_OFFSET = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getStreamingDerivedTimeTimezone()).getRawOffset();

    public TupleFilterVisitor(ColumnRowType inputRowType) {
        super(true);
        this.inputRowType = inputRowType;
    }

    public TupleFilter visitCall(RexCall call) {
        CaseTupleFilter filter = null;
        SqlOperator op = call.getOperator();
        switch (op.getKind()) {
            case AND: {
                filter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
                break;
            }
            case OR: {
                filter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
                break;
            }
            case NOT: {
                filter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.NOT);
                break;
            }
            case EQUALS: {
                filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
                break;
            }
            case GREATER_THAN: {
                filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GT);
                break;
            }
            case LESS_THAN: {
                filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LT);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GTE);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LTE);
                break;
            }
            case NOT_EQUALS: {
                filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.NEQ);
                break;
            }
            case IS_NULL: {
                filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNULL);
                break;
            }
            case IS_NOT_NULL: {
                filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNOTNULL);
                break;
            }
            case CAST: 
            case REINTERPRET: {
                break;
            }
            case CASE: {
                filter = new CaseTupleFilter();
                break;
            }
            case OTHER: {
                if (op.getName().equalsIgnoreCase("extract_date")) {
                    filter = new ExtractTupleFilter(TupleFilter.FilterOperatorEnum.EXTRACT);
                    break;
                }
                filter = Functions.getFunctionTupleFilter((String)op.getName());
                break;
            }
            case LIKE: 
            case OTHER_FUNCTION: {
                filter = Functions.getFunctionTupleFilter((String)op.getName());
                break;
            }
            case PLUS: 
            case MINUS: 
            case TIMES: 
            case DIVIDE: {
                TupleFilter f = this.dealWithTrivialExpr(call);
                if (f != null) {
                    return f;
                }
                filter = new UnsupportedTupleFilter(TupleFilter.FilterOperatorEnum.UNSUPPORTED);
                break;
            }
            default: {
                filter = new UnsupportedTupleFilter(TupleFilter.FilterOperatorEnum.UNSUPPORTED);
            }
        }
        for (RexNode operand : call.operands) {
            TupleFilter childFilter = (TupleFilter)operand.accept((RexVisitor)this);
            if (filter == null) {
                filter = this.cast(childFilter, call.type);
                continue;
            }
            filter.addChild(childFilter);
        }
        if (op.getKind() == SqlKind.OR) {
            filter = TupleFilterVisitor.mergeToInClause((TupleFilter)filter);
        } else if (op.getKind() == SqlKind.NOT) {
            assert (filter.getChildren().size() == 1);
            filter = ((TupleFilter)filter.getChildren().get(0)).reverse();
        }
        return filter;
    }

    private TupleFilter dealWithTrivialExpr(RexCall call) {
        ImmutableList operators = call.operands;
        if (operators.size() != 2) {
            return null;
        }
        BigDecimal left = null;
        BigDecimal right = null;
        for (RexNode rexNode : operators) {
            if (!(rexNode instanceof RexLiteral)) {
                return null;
            }
            RexLiteral temp = (RexLiteral)rexNode;
            if (temp.getType().getFamily() != SqlTypeFamily.NUMERIC || !(temp.getValue() instanceof BigDecimal)) {
                return null;
            }
            if (left == null) {
                left = (BigDecimal)temp.getValue();
                continue;
            }
            right = (BigDecimal)temp.getValue();
        }
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        switch (call.op.getKind()) {
            case PLUS: {
                return new ConstantTupleFilter((Object)left.add(right).toString());
            }
            case MINUS: {
                return new ConstantTupleFilter((Object)left.subtract(right).toString());
            }
            case TIMES: {
                return new ConstantTupleFilter((Object)left.multiply(right).toString());
            }
            case DIVIDE: {
                return new ConstantTupleFilter((Object)left.divide(right).toString());
            }
        }
        return null;
    }

    private TupleFilter cast(TupleFilter filter, RelDataType type) {
        if (!(filter instanceof ConstantTupleFilter)) {
            return filter;
        }
        ConstantTupleFilter constFilter = (ConstantTupleFilter)filter;
        if (type.getFamily() == SqlTypeFamily.DATE || type.getFamily() == SqlTypeFamily.DATETIME || type.getFamily() == SqlTypeFamily.TIMESTAMP) {
            ArrayList newValues = Lists.newArrayList();
            for (Object v : constFilter.getValues()) {
                if (v == null) {
                    newValues.add(null);
                    continue;
                }
                long ts = DateFormat.stringToMillis((String)v.toString());
                if (this.autoJustByTimezone && (type.getFamily() == SqlTypeFamily.TIMESTAMP || type.getFamily() == SqlTypeFamily.DATETIME)) {
                    ts -= TIME_ZONE_OFFSET;
                }
                newValues.add(String.valueOf(ts));
            }
            constFilter = new ConstantTupleFilter((Collection)newValues);
        }
        return constFilter;
    }

    @VisibleForTesting
    static TupleFilter mergeToInClause(TupleFilter filter) {
        List children = filter.getChildren();
        if (children.isEmpty()) {
            return filter;
        }
        HashMap inColumnMap = Maps.newHashMap();
        LinkedList extraFilters = Lists.newLinkedList();
        for (TupleFilter child : children) {
            CompareTupleFilter compFilter;
            TblColRef column;
            if (child.getOperator() == TupleFilter.FilterOperatorEnum.EQ && (column = (compFilter = (CompareTupleFilter)child).getColumn()) != null) {
                Pair tmpValue = (Pair)inColumnMap.get(column);
                if (tmpValue == null) {
                    HashSet inValues = Sets.newHashSet();
                    HashMap dynamicVariables = Maps.newHashMap();
                    tmpValue = new Pair((Object)inValues, (Object)dynamicVariables);
                    inColumnMap.put(column, tmpValue);
                }
                ((Set)tmpValue.getFirst()).addAll(compFilter.getValues());
                ((Map)tmpValue.getSecond()).putAll(compFilter.getVariables());
                continue;
            }
            extraFilters.add(child);
        }
        children.clear();
        LogicalTupleFilter ret = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
        ret.addChildren((List)extraFilters);
        for (Map.Entry entry : inColumnMap.entrySet()) {
            CompareTupleFilter inFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.IN);
            inFilter.addChild((TupleFilter)new ColumnTupleFilter((TblColRef)entry.getKey()));
            inFilter.addChild((TupleFilter)new ConstantTupleFilter((Collection)((Pair)entry.getValue()).getFirst()));
            inFilter.getVariables().putAll((Map)((Pair)entry.getValue()).getSecond());
            ret.addChild((TupleFilter)inFilter);
        }
        return ret.getChildren().size() == 1 ? (TupleFilter)ret.getChildren().get(0) : ret;
    }

    public TupleFilter visitLocalRef(RexLocalRef localRef) {
        throw new UnsupportedOperationException("local ref:" + localRef);
    }

    public TupleFilter visitInputRef(RexInputRef inputRef) {
        TblColRef column = this.inputRowType.getColumnByIndex(inputRef.getIndex());
        ColumnTupleFilter filter = new ColumnTupleFilter(column);
        return filter;
    }

    private String normToTwoDigits(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }

    public TupleFilter visitLiteral(RexLiteral literal) {
        Object strValue = null;
        Comparable literalValue = literal.getValue();
        if (literalValue instanceof NlsString) {
            strValue = ((NlsString)literalValue).getValue();
        } else if (literalValue instanceof GregorianCalendar) {
            GregorianCalendar g = (GregorianCalendar)literalValue;
            strValue = Long.toString(g.getTimeInMillis());
        } else {
            strValue = literalValue instanceof TimeUnitRange ? ((TimeUnitRange)literalValue).name() : (literalValue == null ? null : literalValue.toString());
        }
        ConstantTupleFilter filter = new ConstantTupleFilter(strValue);
        return filter;
    }

    public TupleFilter visitDynamicParam(RexDynamicParam dynamicParam) {
        String name = dynamicParam.getName();
        DynamicTupleFilter filter = new DynamicTupleFilter(name);
        return filter;
    }

    public void setAutoJustByTimezone(boolean autoJustByTimezone) {
        this.autoJustByTimezone = autoJustByTimezone;
    }
}

