/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.query.QueryConnection;

public class QueryCli {
    private static final Option OPTION_METADATA;
    private static final Option OPTION_SQL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(OPTION_METADATA);
        options.addOption(OPTION_SQL);
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(options, args);
        KylinConfig config = KylinConfig.createInstanceFromUri((String)commandLine.getOptionValue(OPTION_METADATA.getOpt()));
        String sql = commandLine.getOptionValue(OPTION_SQL.getOpt());
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = QueryConnection.getConnection(null);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            int n = 0;
            ResultSetMetaData meta = rs.getMetaData();
            while (rs.next()) {
                ++n;
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    System.out.println(n + " - " + meta.getColumnLabel(i) + ":\t" + rs.getObject(i));
                }
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(rs);
            DBUtils.closeQuietly((Statement)stmt);
            DBUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DBUtils.closeQuietly((ResultSet)rs);
        DBUtils.closeQuietly((Statement)stmt);
        DBUtils.closeQuietly((Connection)conn);
    }

    static {
        OptionBuilder.withArgName((String)"metadata url");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Metadata URL");
        OPTION_METADATA = OptionBuilder.create((String)"metadata");
        OptionBuilder.withArgName((String)"input sql");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"SQL");
        OPTION_SQL = OptionBuilder.create((String)"sql");
    }
}

