/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.query.util.PushDownExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownUtil {
    private static final Logger logger = LoggerFactory.getLogger(PushDownUtil.class);

    private PushDownUtil() {
        throw new IllegalStateException("Class PushDownUtil is an utility class !");
    }

    public static Pair<List<List<String>>, List<SelectedColumnMeta>> tryPushDownSelectQuery(String project, String sql, String defaultSchema, SQLException sqlException, boolean isPrepare, KylinConfig kylinConfig) throws Exception {
        PushDownExecutor executor = new PushDownExecutor(kylinConfig);
        return executor.pushDownQuery(project, sql, defaultSchema, sqlException, true, isPrepare);
    }

    public static Pair<List<List<String>>, List<SelectedColumnMeta>> tryPushDownNonSelectQuery(String project, String sql, String defaultSchema, boolean isPrepare) throws Exception {
        PushDownExecutor executor = new PushDownExecutor(null);
        return executor.pushDownQuery(project, sql, defaultSchema, null, true, isPrepare);
    }

    static String schemaCompletion(String inputSql, String schema) throws SqlParseException {
        if (inputSql == null || inputSql.equals("")) {
            return "";
        }
        SqlNode node = CalciteParser.parse((String)inputSql);
        FromTablesVisitor ftv = new FromTablesVisitor();
        node.accept((SqlVisitor)ftv);
        List<SqlNode> tablesWithoutSchema = ftv.getTablesWithoutSchema();
        if (tablesWithoutSchema.isEmpty()) {
            return inputSql;
        }
        ArrayList<Pair> tablesPos = new ArrayList<Pair>();
        for (SqlNode tables : tablesWithoutSchema) {
            tablesPos.add(CalciteParser.getReplacePos((SqlNode)tables, (String)inputSql));
        }
        Collections.sort(tablesPos, new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                int r = (Integer)o2.getFirst() - (Integer)o1.getFirst();
                return r == 0 ? (Integer)o2.getSecond() - (Integer)o1.getSecond() : r;
            }
        });
        StrBuilder afterConvert = new StrBuilder(inputSql);
        for (Pair pos : tablesPos) {
            String tableWithSchema = schema + "." + inputSql.substring((Integer)pos.getFirst(), (Integer)pos.getSecond());
            afterConvert.replace(((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), tableWithSchema);
        }
        return afterConvert.toString();
    }

    static class FromTablesVisitor
    implements SqlVisitor<SqlNode> {
        private List<SqlNode> tables = new ArrayList<SqlNode>();
        private List<SqlNode> withTables = new ArrayList<SqlNode>();

        FromTablesVisitor() {
        }

        List<SqlNode> getTablesWithoutSchema() {
            ArrayList sqlNodes = Lists.newArrayList();
            ArrayList withs = Lists.newArrayList();
            for (SqlNode withTable : this.withTables) {
                withs.add(((SqlIdentifier)withTable).names.get(0));
            }
            for (SqlNode table : this.tables) {
                SqlIdentifier identifier = (SqlIdentifier)table;
                if (withs.contains(identifier.names.get(0))) continue;
                sqlNodes.add(identifier);
            }
            return sqlNodes;
        }

        public SqlNode visit(SqlNodeList nodeList) {
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode node = nodeList.get(i);
                if (!(node instanceof SqlWithItem)) continue;
                SqlWithItem item = (SqlWithItem)node;
                item.query.accept((SqlVisitor)this);
            }
            return null;
        }

        public SqlNode visit(SqlLiteral literal) {
            return null;
        }

        public SqlNode visit(SqlCall call) {
            SqlBasicCall node;
            if (call instanceof SqlSelect) {
                SqlSelect select = (SqlSelect)call;
                select.getFrom().accept((SqlVisitor)this);
                return null;
            }
            if (call instanceof SqlOrderBy) {
                SqlOrderBy orderBy = (SqlOrderBy)call;
                orderBy.query.accept((SqlVisitor)this);
                return null;
            }
            if (call instanceof SqlWith) {
                SqlWith sqlWith = (SqlWith)call;
                List list = sqlWith.withList.getList();
                for (SqlNode sqlNode : list) {
                    this.withTables.add((SqlNode)((SqlWithItem)sqlNode).name);
                }
                sqlWith.body.accept((SqlVisitor)this);
                sqlWith.withList.accept((SqlVisitor)this);
            }
            if (call instanceof SqlBasicCall) {
                node = (SqlBasicCall)call;
                node.getOperands()[0].accept((SqlVisitor)this);
                return null;
            }
            if (call instanceof SqlJoin) {
                node = (SqlJoin)call;
                node.getLeft().accept((SqlVisitor)this);
                node.getRight().accept((SqlVisitor)this);
                return null;
            }
            return null;
        }

        public SqlNode visit(SqlIdentifier id) {
            if (id.names.size() == 1) {
                this.tables.add((SqlNode)id);
            }
            return null;
        }

        public SqlNode visit(SqlDataTypeSpec type) {
            return null;
        }

        public SqlNode visit(SqlDynamicParam param) {
            return null;
        }

        public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
            return null;
        }
    }
}

