/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.query.schema.OLAPTable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLAPTableTest
extends LocalFileMetadataTestCase {
    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testCreateSqlType() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        DataType kylinDataType = DataType.getType((String)"array<string>");
        RelDataType relDataType = OLAPTable.createSqlType((RelDataTypeFactory)typeFactory, (DataType)kylinDataType, (boolean)true);
        Assert.assertTrue((boolean)(relDataType instanceof ArraySqlType));
        Assert.assertEquals((Object)SqlTypeName.ARRAY, (Object)relDataType.getSqlTypeName());
        Assert.assertTrue((boolean)(relDataType.getComponentType() instanceof BasicSqlType));
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)relDataType.getComponentType().getSqlTypeName());
        Assert.assertTrue((boolean)relDataType.isNullable());
        kylinDataType = DataType.getType((String)"array<>");
        boolean catchedEx = false;
        try {
            OLAPTable.createSqlType((RelDataTypeFactory)typeFactory, (DataType)kylinDataType, (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Unrecognized data type array<>", (Object)ex.getMessage());
            catchedEx = true;
        }
        Assert.assertTrue((boolean)catchedEx);
        kylinDataType = DataType.getType((String)"array<AAA>");
        catchedEx = false;
        try {
            OLAPTable.createSqlType((RelDataTypeFactory)typeFactory, (DataType)kylinDataType, (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().startsWith("bad data type -- aaa"));
            catchedEx = true;
        }
        Assert.assertTrue((boolean)catchedEx);
    }
}

