/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.schema.OLAPTable;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTableEnumerator
implements Enumerator<Object[]> {
    private static final Logger logger = LoggerFactory.getLogger(LookupTableEnumerator.class);
    private final ILookupTable lookupTable;
    private final List<ColumnDesc> colDescs;
    private final Object[] current;
    private Iterator<String[]> iterator;

    public LookupTableEnumerator(OLAPContext olapContext) {
        CubeInstance cube = null;
        if (olapContext.realization instanceof CubeInstance) {
            cube = (CubeInstance)olapContext.realization;
            ProjectInstance project = cube.getProjectInstance();
            List realizationEntries = project.getRealizationEntries();
            String lookupTableName = olapContext.firstTableScan.getTableName();
            CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)cube.getConfig());
            cube = cubeMgr.findLatestSnapshot(realizationEntries, lookupTableName);
            olapContext.realization = cube;
        } else if (olapContext.realization instanceof HybridInstance) {
            HybridInstance hybridInstance = (HybridInstance)olapContext.realization;
            IRealization latestRealization = hybridInstance.getLatestRealization();
            if (latestRealization instanceof CubeInstance) {
                cube = (CubeInstance)latestRealization;
            } else {
                throw new IllegalStateException();
            }
        }
        String lookupTableName = olapContext.firstTableScan.getTableName();
        DimensionDesc dim = cube.getDescriptor().findDimensionByTable(lookupTableName);
        if (dim == null) {
            throw new IllegalStateException("No dimension with derived columns found for lookup table " + lookupTableName + ", cube desc " + cube.getDescriptor());
        }
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)cube.getConfig());
        this.lookupTable = cubeMgr.getLookupTable(cube.getLatestReadySegment(), dim.getJoin());
        OLAPTable olapTable = olapContext.firstTableScan.getOlapTable();
        this.colDescs = olapTable.getSourceColumns();
        this.current = new Object[this.colDescs.size()];
        this.reset();
    }

    public boolean moveNext() {
        boolean hasNext = this.iterator.hasNext();
        if (hasNext) {
            String[] row = this.iterator.next();
            int n = this.colDescs.size();
            for (int i = 0; i < n; ++i) {
                ColumnDesc colDesc = this.colDescs.get(i);
                int colIdx = colDesc.getZeroBasedIndex();
                this.current[i] = colIdx >= 0 ? Tuple.convertOptiqCellValue((String)row[colIdx], (String)colDesc.getUpgradedType().getName()) : null;
            }
        }
        return hasNext;
    }

    public Object[] current() {
        return Arrays.copyOf(this.current, this.current.length);
    }

    public void reset() {
        this.iterator = this.lookupTable.iterator();
    }

    public void close() {
        try {
            this.lookupTable.close();
        }
        catch (IOException e) {
            logger.error("error when close lookup table", (Throwable)e);
        }
    }
}

