/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.adhoc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.query.adhoc.JdbcPushDownConnectionManager;
import org.apache.kylin.source.adhocquery.AbstractPushdownRunner;

public class PushDownRunnerJdbcImpl
extends AbstractPushdownRunner {
    private JdbcPushDownConnectionManager manager = null;

    public void init(KylinConfig config) {
        try {
            this.manager = JdbcPushDownConnectionManager.getConnectionManager();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String query, List<List<String>> results, List<SelectedColumnMeta> columnMetas) throws Exception {
        Statement statement = null;
        Connection connection = this.manager.getConnection();
        ResultSet resultSet = null;
        ResultSetMetaData metaData = null;
        int columnCount = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            this.extractResults(resultSet, results);
            metaData = resultSet.getMetaData();
            columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                SelectedColumnMeta columnMeta = this.extractColumnMeta(metaData, i);
                columnMetas.add(columnMeta);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(resultSet);
            DBUtils.closeQuietly((Statement)statement);
            this.manager.close(connection);
            throw throwable;
        }
        DBUtils.closeQuietly((ResultSet)resultSet);
        DBUtils.closeQuietly((Statement)statement);
        this.manager.close(connection);
    }

    private SelectedColumnMeta extractColumnMeta(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String tableName;
        String catelogName;
        String schemaName;
        String columnName;
        String columnLabel;
        int columnDisplaySize;
        boolean isSigned;
        int isNullable;
        boolean isCurrency;
        boolean isSearchable;
        boolean isCaseSensitive;
        boolean isAutoIncrement;
        block37: {
            isAutoIncrement = false;
            try {
                isAutoIncrement = resultSetMetaData.isAutoIncrement(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isCaseSensitive = false;
            try {
                isCaseSensitive = resultSetMetaData.isCaseSensitive(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isSearchable = false;
            try {
                isSearchable = resultSetMetaData.isSearchable(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isCurrency = false;
            try {
                isCurrency = resultSetMetaData.isCurrency(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isNullable = 2;
            try {
                isNullable = resultSetMetaData.isNullable(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isSigned = false;
            try {
                isSigned = resultSetMetaData.isSigned(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            columnDisplaySize = 0;
            try {
                columnDisplaySize = resultSetMetaData.getColumnDisplaySize(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            columnLabel = null;
            try {
                columnLabel = resultSetMetaData.getColumnLabel(columnIndex);
                if (columnLabel.contains(".")) {
                    columnLabel = StringUtils.substringAfterLast((String)columnLabel, (String)".");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            columnName = null;
            try {
                columnName = resultSetMetaData.getColumnName(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            schemaName = null;
            try {
                schemaName = resultSetMetaData.getSchemaName(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            catelogName = null;
            try {
                catelogName = resultSetMetaData.getCatalogName(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            tableName = null;
            try {
                tableName = resultSetMetaData.getTableName(columnIndex);
            }
            catch (SQLException e) {
                if (!columnLabel.contains(".")) break block37;
                tableName = StringUtils.substringBeforeLast((String)columnLabel, (String)".");
            }
        }
        int precision = 0;
        try {
            precision = resultSetMetaData.getPrecision(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        int scale = 0;
        try {
            scale = resultSetMetaData.getScale(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String columnTypeName = null;
        try {
            columnTypeName = resultSetMetaData.getColumnTypeName(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        int columnType = PushDownRunnerJdbcImpl.toSqlType(columnTypeName);
        boolean isReadOnly = false;
        try {
            isReadOnly = resultSetMetaData.isReadOnly(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        boolean isWritable = false;
        try {
            isWritable = resultSetMetaData.isWritable(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        boolean isDefinitelyWritable = false;
        try {
            isDefinitelyWritable = resultSetMetaData.isDefinitelyWritable(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SelectedColumnMeta columnMeta = new SelectedColumnMeta(isAutoIncrement, isCaseSensitive, isSearchable, isCurrency, isNullable, isSigned, columnDisplaySize, columnLabel, columnName, schemaName, catelogName, tableName, precision, scale, columnType, columnTypeName, isReadOnly, isWritable, isDefinitelyWritable);
        return columnMeta;
    }

    public static int toSqlType(String type) throws SQLException {
        if ("string".equalsIgnoreCase(type)) {
            return 12;
        }
        if ("varchar".equalsIgnoreCase(type)) {
            return 12;
        }
        if ("char".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("float".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("real".equalsIgnoreCase(type)) {
            return 7;
        }
        if ("double".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return 16;
        }
        if ("tinyint".equalsIgnoreCase(type)) {
            return -6;
        }
        if ("smallint".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("int".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("bigint".equalsIgnoreCase(type)) {
            return -5;
        }
        if ("date".equalsIgnoreCase(type)) {
            return 91;
        }
        if ("timestamp".equalsIgnoreCase(type)) {
            return 93;
        }
        if ("decimal".equalsIgnoreCase(type)) {
            return 3;
        }
        if ("binary".equalsIgnoreCase(type)) {
            return -2;
        }
        if ("map".equalsIgnoreCase(type)) {
            return 2000;
        }
        if ("array".equalsIgnoreCase(type)) {
            return 2003;
        }
        if ("struct".equalsIgnoreCase(type)) {
            return 2002;
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String sql) throws Exception {
        Statement statement = null;
        Connection connection = this.manager.getConnection();
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        finally {
            DBUtils.closeQuietly((Statement)statement);
            this.manager.close(connection);
        }
    }

    private void extractResults(ResultSet resultSet, List<List<String>> results) throws SQLException {
        LinkedList<String> oneRow = new LinkedList<String>();
        while (resultSet.next()) {
            for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                oneRow.add(resultSet.getString(i + 1));
            }
            results.add(new LinkedList(oneRow));
            oneRow.clear();
        }
    }
}

