/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.query.util.QueryUtil;

public class DefaultQueryTransformer
implements QueryUtil.IQueryTransformer {
    private static final String S0 = "\\s*";
    private static final String S1 = "\\s";
    private static final String SM = "\\s+";
    private static final Pattern PTN_GROUP_BY = Pattern.compile("\\sGROUP\\s+BY\\s", 2);
    private static final Pattern PTN_HAVING_COUNT_GREATER_THAN_ZERO = Pattern.compile("\\sHAVING\\s+[(]?\\s*COUNT\\s*[(]\\s*1\\s*[)]\\s*>\\s*0\\s*[)]?", 2);
    private static final Pattern PTN_SUM_1 = Pattern.compile("\\s*SUM\\s*[(]\\s*[1]\\s*[)]\\s*", 2);
    private static final Pattern PTN_MIN_1 = Pattern.compile("\\s*MIN\\s*[(]\\s*[1]\\s*[)]\\s*", 2);
    private static final Pattern PTN_MAX_1 = Pattern.compile("\\s*MAX\\s*[(]\\s*[1]\\s*[)]\\s*", 2);
    private static final Pattern PTN_NOT_EQ = Pattern.compile("\\s*!=\\s*", 2);
    private static final Pattern PTN_INTERVAL = Pattern.compile("interval\\s+(floor\\()([\\d\\.]+)(\\))\\s+(second|minute|hour|day|month|year)", 2);
    private static final Pattern PTN_HAVING_ESCAPE_FUNCTION = Pattern.compile("\\{fn\\s+(EXTRACT\\(.*?\\)||CURRENT_TIMESTAMP\\(.*?\\))\\}", 2);
    private static final Pattern PIN_SUM_OF_CAST = Pattern.compile("\\s*SUM\\s*\\(\\s*CAST\\s*\\(\\s*([^\\s,]+)\\s*AS\\s+DOUBLE\\s*\\)\\s*\\)", 2);
    private static final Pattern PIN_SUM_OF_FN_CONVERT = Pattern.compile("\\s*SUM\\s*\\(\\s*\\{\\s*fn\\s+convert\\s*\\(\\s*([^\\s,]+)\\s*,\\s*(SQL_DOUBLE|SQL_BIGINT)\\s*\\)\\s*\\}\\s*\\)", 2);

    @Override
    public String transform(String sql, String project, String defaultSchema) {
        Matcher m;
        while ((m = PIN_SUM_OF_CAST.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + " SUM(" + m.group(1).trim() + ")" + sql.substring(m.end(), sql.length());
        }
        while ((m = PIN_SUM_OF_FN_CONVERT.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + " SUM(" + m.group(1).trim() + ")" + sql.substring(m.end(), sql.length());
        }
        while ((m = PTN_HAVING_ESCAPE_FUNCTION.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + m.group(1) + sql.substring(m.end());
        }
        m = PTN_HAVING_COUNT_GREATER_THAN_ZERO.matcher(sql);
        if (m.find() && !PTN_GROUP_BY.matcher(sql).find()) {
            sql = sql.substring(0, m.start()) + " " + sql.substring(m.end());
        }
        while ((m = PTN_SUM_1.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + " COUNT(1) " + sql.substring(m.end());
        }
        while ((m = PTN_MIN_1.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + " 1 " + sql.substring(m.end());
        }
        while ((m = PTN_MAX_1.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + " 1 " + sql.substring(m.end());
        }
        while ((m = PTN_NOT_EQ.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + " <> " + sql.substring(m.end());
        }
        while ((m = PTN_INTERVAL.matcher(sql)).find()) {
            int value = (int)Math.floor(Double.valueOf(m.group(2)));
            sql = sql.substring(0, m.start(1)) + "'" + value + "'" + sql.substring(m.end(3));
        }
        return sql;
    }
}

