/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.relnode.OLAPTableScan;

public class RealizationCheck {
    private Map<DataModelDesc, List<IncapableReason>> modelIncapableReasons = Maps.newHashMap();
    private Map<CubeDesc, IncapableReason> cubeIncapableReasons = Maps.newHashMap();
    private Map<CubeDesc, Boolean> cubeCapabilities = Maps.newHashMap();
    private Map<DataModelDesc, Map<String, String>> capableModels = Maps.newHashMap();

    public Map<DataModelDesc, List<IncapableReason>> getModelIncapableReasons() {
        return this.modelIncapableReasons;
    }

    public Map<CubeDesc, IncapableReason> getCubeIncapableReasons() {
        return this.cubeIncapableReasons;
    }

    public Map<CubeDesc, Boolean> getCubeCapabilities() {
        return this.cubeCapabilities;
    }

    public void addCapableCube(IRealization realization) {
        if (realization instanceof CubeInstance) {
            this.cubeCapabilities.put(((CubeInstance)realization).getDescriptor(), true);
        }
    }

    public void addIncapableCube(IRealization realization) {
        if (realization instanceof CubeInstance) {
            this.cubeCapabilities.put(((CubeInstance)realization).getDescriptor(), false);
        }
    }

    public void addIncapableCube(IRealization realization, IncapableReason incapableReason) {
        if (realization instanceof CubeInstance) {
            this.cubeCapabilities.put(((CubeInstance)realization).getDescriptor(), false);
            this.cubeIncapableReasons.put(((CubeInstance)realization).getDescriptor(), incapableReason);
        }
    }

    public void addCubeIncapableReason(IRealization realization, IncapableReason incapableReason) {
        if (realization instanceof CubeInstance) {
            this.cubeIncapableReasons.put(((CubeInstance)realization).getDescriptor(), incapableReason);
        }
    }

    public Map<DataModelDesc, Map<String, String>> getCapableModels() {
        return this.capableModels;
    }

    public void addModelIncapableReason(DataModelDesc modelDesc, IncapableReason reason) {
        if (!this.modelIncapableReasons.containsKey(modelDesc)) {
            ArrayList reasons = Lists.newArrayList((Object[])new IncapableReason[]{reason});
            this.modelIncapableReasons.put(modelDesc, reasons);
        } else {
            List<IncapableReason> incapableReasons = this.modelIncapableReasons.get(modelDesc);
            if (!incapableReasons.contains(reason)) {
                incapableReasons.add(reason);
            }
        }
    }

    public void addCapableModel(DataModelDesc modelDesc, Map<String, String> aliasMap) {
        if (!this.capableModels.containsKey(modelDesc)) {
            this.capableModels.put(modelDesc, aliasMap);
        }
    }

    public void addModelIncapableReason(DataModelDesc modelDesc, List<IncapableReason> reasons) {
        this.modelIncapableReasons.put(modelDesc, reasons);
    }

    public boolean isModelCapable() {
        return !this.capableModels.isEmpty() || this.modelIncapableReasons.isEmpty();
    }

    public boolean isCubeCapable() {
        for (Boolean capability : this.cubeCapabilities.values()) {
            if (!capability.booleanValue()) continue;
            return true;
        }
        return this.cubeIncapableReasons.isEmpty();
    }

    public boolean isCapable() {
        return this.isModelCapable() && this.isCubeCapable();
    }

    public static class IncapableReason {
        private IncapableType incapableType;
        private Collection<TblColRef> notFoundColumns;
        private Collection<TblColRef> notFoundDimensions;
        private Collection<FunctionDesc> notFoundMeasures;
        private Collection<TblColRef> unmatchedDimensions;
        private Collection<FunctionDesc> unmatchedAggregations;
        private Collection<OLAPTableScan> notFoundTables;

        public static IncapableReason create(IncapableType incapableType) {
            IncapableReason incapableReason = new IncapableReason();
            incapableReason.setIncapableType(incapableType);
            return incapableReason;
        }

        public static IncapableReason create(CapabilityResult.IncapableCause incapableCause) {
            if (incapableCause == null) {
                return null;
            }
            IncapableReason incapableReason = new IncapableReason();
            IncapableType incapableType = null;
            switch (incapableCause.getIncapableType()) {
                case UNSUPPORT_MASSIN: {
                    incapableType = IncapableType.CUBE_UN_SUPPORT_MASSIN;
                    break;
                }
                case UNMATCHED_DIMENSION: {
                    incapableType = IncapableType.CUBE_UNMATCHED_DIMENSION;
                    break;
                }
                case LIMIT_PRECEDE_AGGR: {
                    incapableType = IncapableType.CUBE_LIMIT_PRECEDE_AGGR;
                    break;
                }
                case UNMATCHED_AGGREGATION: {
                    incapableType = IncapableType.CUBE_UNMATCHED_AGGREGATION;
                    break;
                }
                case UNSUPPORT_RAWQUERY: {
                    incapableType = IncapableType.CUBE_UN_SUPPORT_RAWQUERY;
                    break;
                }
                case II_UNMATCHED_FACT_TABLE: {
                    incapableType = IncapableType.MODEL_FACT_TABLE_NOT_FOUND;
                    break;
                }
                case II_MISSING_COLS: {
                    incapableType = IncapableType.CUBE_NOT_CONTAIN_ALL_COLUMN;
                    break;
                }
            }
            incapableReason.setIncapableType(incapableType);
            incapableReason.setUnmatchedDimensions(incapableCause.getUnmatchedDimensions());
            incapableReason.setUnmatchedAggregations(incapableCause.getUnmatchedAggregations());
            return incapableReason;
        }

        public static IncapableReason notContainAllColumn(Collection<TblColRef> notFoundColumns) {
            IncapableReason incapableReason = new IncapableReason();
            incapableReason.setIncapableType(IncapableType.CUBE_NOT_CONTAIN_ALL_COLUMN);
            incapableReason.setNotFoundColumns(notFoundColumns);
            return incapableReason;
        }

        public static IncapableReason notContainAllDimension(Collection<TblColRef> notFoundDimensions) {
            IncapableReason incapableReason = new IncapableReason();
            incapableReason.setIncapableType(IncapableType.CUBE_NOT_CONTAIN_ALL_DIMENSION);
            incapableReason.setNotFoundDimensions(notFoundDimensions);
            return incapableReason;
        }

        public static IncapableReason notContainAllMeasures(Collection<FunctionDesc> notFoundMeasures) {
            IncapableReason incapableReason = new IncapableReason();
            incapableReason.setIncapableType(IncapableType.CUBE_NOT_CONTAIN_ALL_MEASURE);
            incapableReason.setNotFoundMeasures(notFoundMeasures);
            return incapableReason;
        }

        public static IncapableReason notFoundTables(Collection<OLAPTableScan> notFoundTables) {
            IncapableReason incapableReason = new IncapableReason();
            incapableReason.setIncapableType(IncapableType.CUBE_NOT_CONTAIN_TABLE);
            incapableReason.setNotFoundTables(notFoundTables);
            return incapableReason;
        }

        public void setIncapableType(IncapableType incapableType) {
            this.incapableType = incapableType;
        }

        public void setUnmatchedDimensions(Collection<TblColRef> unmatchedDimensions) {
            this.unmatchedDimensions = unmatchedDimensions;
        }

        public void setUnmatchedAggregations(Collection<FunctionDesc> unmatchedAggregations) {
            this.unmatchedAggregations = unmatchedAggregations;
        }

        public void setNotFoundColumns(Collection<TblColRef> notFoundColumns) {
            this.notFoundColumns = notFoundColumns;
        }

        public void setNotFoundTables(Collection<OLAPTableScan> notFoundTables) {
            this.notFoundTables = notFoundTables;
        }

        public void setNotFoundDimensions(Collection<TblColRef> notFoundDimensions) {
            this.notFoundDimensions = notFoundDimensions;
        }

        public void setNotFoundMeasures(Collection<FunctionDesc> notFoundMeasures) {
            this.notFoundMeasures = notFoundMeasures;
        }

        public Collection<TblColRef> getNotFoundDimensions() {
            return this.notFoundDimensions;
        }

        public Collection<FunctionDesc> getNotFoundMeasures() {
            return this.notFoundMeasures;
        }

        public IncapableType getIncapableType() {
            return this.incapableType;
        }

        public Collection<TblColRef> getUnmatchedDimensions() {
            return this.unmatchedDimensions;
        }

        public Collection<TblColRef> getNotFoundColumns() {
            return this.notFoundColumns;
        }

        public Collection<FunctionDesc> getUnmatchedAggregations() {
            return this.unmatchedAggregations;
        }

        public Collection<OLAPTableScan> getNotFoundTables() {
            return this.notFoundTables;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncapableReason that = (IncapableReason)o;
            if (this.incapableType != that.incapableType) {
                return false;
            }
            if (this.notFoundColumns != null ? !this.notFoundColumns.equals(that.notFoundColumns) : that.notFoundColumns != null) {
                return false;
            }
            if (this.notFoundDimensions != null ? !this.notFoundDimensions.equals(that.notFoundDimensions) : that.notFoundDimensions != null) {
                return false;
            }
            if (this.notFoundMeasures != null ? !this.notFoundMeasures.equals(that.notFoundMeasures) : that.notFoundMeasures != null) {
                return false;
            }
            if (this.unmatchedDimensions != null ? !this.unmatchedDimensions.equals(that.unmatchedDimensions) : that.unmatchedDimensions != null) {
                return false;
            }
            if (this.unmatchedAggregations != null ? !this.unmatchedAggregations.equals(that.unmatchedAggregations) : that.unmatchedAggregations != null) {
                return false;
            }
            return this.notFoundTables != null ? this.notFoundTables.equals(that.notFoundTables) : that.notFoundTables == null;
        }

        public int hashCode() {
            int result = this.incapableType != null ? this.incapableType.hashCode() : 0;
            result = 31 * result + (this.notFoundColumns != null ? this.notFoundColumns.hashCode() : 0);
            result = 31 * result + (this.notFoundDimensions != null ? this.notFoundDimensions.hashCode() : 0);
            result = 31 * result + (this.notFoundMeasures != null ? this.notFoundMeasures.hashCode() : 0);
            result = 31 * result + (this.unmatchedDimensions != null ? this.unmatchedDimensions.hashCode() : 0);
            result = 31 * result + (this.unmatchedAggregations != null ? this.unmatchedAggregations.hashCode() : 0);
            result = 31 * result + (this.notFoundTables != null ? this.notFoundTables.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.incapableType.toString());
            switch (this.incapableType) {
                case CUBE_NOT_CONTAIN_TABLE: {
                    if (this.notFoundTables == null) break;
                    sb.append('[');
                    sb.append(StringUtils.join((Object[])this.notFoundTables.toArray(), (String)", "));
                    sb.append(']');
                    break;
                }
                case CUBE_NOT_CONTAIN_ALL_COLUMN: {
                    if (this.notFoundColumns == null) break;
                    sb.append('[');
                    sb.append(StringUtils.join((Object[])this.notFoundColumns.toArray(), (String)", "));
                    sb.append(']');
                    break;
                }
                case CUBE_NOT_CONTAIN_ALL_DIMENSION: {
                    if (this.notFoundDimensions == null) break;
                    sb.append('[');
                    sb.append(StringUtils.join((Object[])this.notFoundDimensions.toArray(), (String)", "));
                    sb.append(']');
                    break;
                }
                case CUBE_NOT_CONTAIN_ALL_MEASURE: {
                    if (this.notFoundMeasures == null) break;
                    sb.append('[');
                    sb.append(StringUtils.join((Object[])this.notFoundMeasures.toArray(), (String)", "));
                    sb.append(']');
                    break;
                }
                case CUBE_UNMATCHED_DIMENSION: {
                    if (this.unmatchedDimensions == null) break;
                    sb.append('[');
                    sb.append(StringUtils.join((Object[])this.unmatchedDimensions.toArray(), (String)", "));
                    sb.append(']');
                    break;
                }
                case CUBE_UNMATCHED_AGGREGATION: {
                    if (this.unmatchedAggregations == null) break;
                    sb.append('[');
                    sb.append(StringUtils.join((Object[])this.unmatchedAggregations.toArray(), (String)", "));
                    sb.append(']');
                    break;
                }
                case CUBE_NOT_READY: 
                case CUBE_BLACK_OUT_REALIZATION: 
                case CUBE_UN_SUPPORT_MASSIN: 
                case CUBE_UN_SUPPORT_RAWQUERY: 
                case CUBE_LIMIT_PRECEDE_AGGR: 
                case CUBE_OTHER_CUBE_INCAPABLE: {
                    break;
                }
                case MODEL_UNMATCHED_JOIN: 
                case MODEL_JOIN_TYPE_UNMATCHED: 
                case MODEL_JOIN_CONDITION_UNMATCHED: 
                case MODEL_JOIN_NOT_FOUND: 
                case MODEL_BAD_JOIN_SEQUENCE: 
                case MODEL_FACT_TABLE_NOT_FOUND: 
                case MODEL_OTHER_MODEL_INCAPABLE: {
                    break;
                }
            }
            return sb.toString();
        }
    }

    public static enum IncapableType {
        CUBE_NOT_READY,
        CUBE_NOT_CONTAIN_TABLE,
        CUBE_NOT_CONTAIN_ALL_COLUMN,
        CUBE_NOT_CONTAIN_ALL_DIMENSION,
        CUBE_NOT_CONTAIN_ALL_MEASURE,
        CUBE_BLACK_OUT_REALIZATION,
        CUBE_UN_SUPPORT_MASSIN,
        CUBE_UN_SUPPORT_RAWQUERY,
        CUBE_UNMATCHED_DIMENSION,
        CUBE_LIMIT_PRECEDE_AGGR,
        CUBE_UNMATCHED_AGGREGATION,
        CUBE_OTHER_CUBE_INCAPABLE,
        MODEL_UNMATCHED_JOIN,
        MODEL_JOIN_TYPE_UNMATCHED,
        MODEL_JOIN_CONDITION_UNMATCHED,
        MODEL_JOIN_NOT_FOUND,
        MODEL_BAD_JOIN_SEQUENCE,
        MODEL_FACT_TABLE_NOT_FOUND,
        MODEL_OTHER_MODEL_INCAPABLE;

    }
}

