/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableAggregate;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.ParamAsMeasureCount;
import org.apache.kylin.metadata.expression.CaseTupleExpression;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.ExpressionCountDistributor;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.NumberTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.SumDynamicFunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.KylinAggregateCall;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPAggregateRel
extends Aggregate
implements OLAPRel {
    static final Map<String, String> AGGR_FUNC_MAP = new HashMap<String, String>();
    static final Map<String, Integer> AGGR_FUNC_PARAM_AS_MEASURE_MAP = new HashMap<String, Integer>();
    OLAPContext context;
    ColumnRowType columnRowType;
    private boolean afterAggregate;
    private Map<Integer, AggregateCall> hackAggCalls;
    private List<AggregateCall> rewriteAggCalls;
    private List<TblColRef> groups;
    private List<FunctionDesc> aggregations;
    private boolean rewriting;

    static String getSqlFuncName(AggregateCall aggCall) {
        String sqlName = aggCall.getAggregation().getName();
        if (aggCall.isDistinct()) {
            sqlName = sqlName + "_DISTINCT";
        }
        return sqlName;
    }

    public static String getAggrFuncName(AggregateCall aggCall) {
        String sqlName = OLAPAggregateRel.getSqlFuncName(aggCall);
        String funcName = AGGR_FUNC_MAP.get(sqlName);
        if (funcName == null) {
            throw new IllegalStateException("Non-support aggregation " + sqlName);
        }
        return funcName;
    }

    public OLAPAggregateRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traits, child, indicator, groupSet, groupSets, aggCalls);
        Preconditions.checkArgument((this.getConvention() == OLAPRel.CONVENTION ? 1 : 0) != 0);
        this.afterAggregate = false;
        this.rewriteAggCalls = aggCalls;
        this.rowType = this.getRowType();
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new OLAPAggregateRel(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create OLAPAggregateRel!", e);
        }
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = this.getGroupType() == Aggregate.Group.SIMPLE ? super.computeSelfCost(planner, mq).multiplyBy(0.05) : super.computeSelfCost(planner, mq).multiplyBy(0.05).plus(planner.getCost(this.getInput(), mq)).multiplyBy((double)this.groupSets.size() * 1.5);
        return cost;
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.fixSharedOlapTableScan((SingleRel)this);
        implementor.visitChild(this.getInput(), this);
        this.context = implementor.getContext();
        this.columnRowType = this.buildColumnRowType();
        this.afterAggregate = this.context.afterAggregate;
        if (!this.afterAggregate) {
            this.addToContextGroupBy(this.groups);
            this.context.aggregations.addAll(this.aggregations);
            this.context.aggrOutCols.addAll(this.columnRowType.getAllColumns().subList(this.groups.size(), this.columnRowType.getAllColumns().size()));
            this.context.afterAggregate = true;
            if (this.context.afterLimit) {
                this.context.limitPrecedesAggr = true;
            }
        } else {
            for (AggregateCall aggCall : this.aggCalls) {
                if (!aggCall.isDistinct()) continue;
                throw new IllegalStateException("Distinct count is only allowed in innermost sub-query.");
            }
        }
    }

    ColumnRowType buildColumnRowType() {
        this.buildGroups();
        this.buildAggregations();
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>(this.rowType.getFieldCount());
        columns.addAll(this.groups);
        if (this.indicator) {
            HashSet containedNames = Sets.newHashSet();
            for (TblColRef groupCol : this.groups) {
                String base;
                String name = base = "i$" + groupCol.getName();
                int i = 0;
                while (containedNames.contains(name)) {
                    name = base + "_" + i++;
                }
                containedNames.add(name);
                TblColRef indicatorCol = TblColRef.newInnerColumn((String)name, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
                columns.add(indicatorCol);
            }
        }
        for (int i = 0; i < this.aggregations.size(); ++i) {
            String aggOutName;
            FunctionDesc aggFunc = this.aggregations.get(i);
            if (aggFunc != null) {
                aggOutName = aggFunc.getRewriteFieldName();
            } else {
                AggregateCall aggCall = this.rewriteAggCalls.get(i);
                int index = (Integer)aggCall.getArgList().get(0);
                aggOutName = OLAPAggregateRel.getSqlFuncName(aggCall) + "_" + inputColumnRowType.getColumnByIndex(index).getIdentity().replace('.', '_') + "_";
            }
            TblColRef aggOutCol = TblColRef.newInnerColumn((String)aggOutName, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
            aggOutCol.getColumnDesc().setId("" + (i + 1));
            columns.add(aggOutCol);
        }
        return new ColumnRowType(columns);
    }

    TblColRef buildRewriteColumn(FunctionDesc aggFunc) {
        if (!aggFunc.needRewriteField()) {
            throw new IllegalStateException("buildRewriteColumn on a aggrFunc that does not need rewrite " + aggFunc);
        }
        String colName = aggFunc.getRewriteFieldName();
        TblColRef colRef = this.context.firstTableScan.makeRewriteColumn(colName);
        return colRef;
    }

    void buildGroups() {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        this.groups = Lists.newArrayList();
        int i = this.getGroupSet().nextSetBit(0);
        while (i >= 0) {
            TupleExpression tupleExpression = inputColumnRowType.getSourceColumnsByIndex(i);
            TblColRef groupOutCol = inputColumnRowType.getColumnByIndex(i);
            if (tupleExpression instanceof ColumnTupleExpression) {
                this.groups.add(((ColumnTupleExpression)tupleExpression).getColumn());
            } else if (this.context.isDynamicColumnEnabled()) {
                boolean ifPushDown;
                Pair cols = ExpressionColCollector.collectColumnsPair((TupleExpression)tupleExpression);
                boolean bl = ifPushDown = !this.afterAggregate;
                if (ifPushDown && !((Set)cols.getSecond()).isEmpty()) {
                    ifPushDown = false;
                }
                if (ifPushDown) {
                    for (TblColRef dimCol : (Set)cols.getFirst()) {
                        if (this.context.belongToFactTableDims(dimCol)) continue;
                        ifPushDown = false;
                        break;
                    }
                }
                if (ifPushDown) {
                    this.groups.add(groupOutCol);
                    this.context.dynGroupBy.put(groupOutCol, tupleExpression);
                } else {
                    this.groups.addAll((Collection)cols.getFirst());
                    this.groups.addAll((Collection)cols.getSecond());
                    this.context.dynamicFields.remove(groupOutCol);
                }
            } else {
                Set srcCols = ExpressionColCollector.collectColumns((TupleExpression)tupleExpression);
                if (srcCols.isEmpty()) {
                    srcCols.add(groupOutCol);
                }
                this.groups.addAll(srcCols);
            }
            i = this.getGroupSet().nextSetBit(i + 1);
        }
    }

    void buildAggregations() {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        this.aggregations = Lists.newArrayList();
        this.hackAggCalls = Maps.newHashMap();
        for (int i = 0; i < this.rewriteAggCalls.size(); ++i) {
            AggregateCall aggCall = this.rewriteAggCalls.get(i);
            ParameterDesc parameter = null;
            List argList = aggCall.getArgList();
            if (!argList.isEmpty()) {
                ArrayList columns = Lists.newArrayList();
                String funcName = OLAPAggregateRel.getSqlFuncName(aggCall);
                int columnsCount = aggCall.getArgList().size();
                if (AGGR_FUNC_PARAM_AS_MEASURE_MAP.containsKey(funcName)) {
                    int asMeasureCnt = AGGR_FUNC_PARAM_AS_MEASURE_MAP.get(funcName);
                    columnsCount = asMeasureCnt > 0 ? asMeasureCnt : (columnsCount += asMeasureCnt);
                }
                for (Integer index : aggCall.getArgList().subList(0, columnsCount)) {
                    TblColRef column = inputColumnRowType.getColumnByIndex(index);
                    columns.add(column);
                }
                if (!columns.isEmpty()) {
                    parameter = ParameterDesc.newInstance((Object[])columns.toArray(new TblColRef[columns.size()]));
                }
            }
            if (this.context.isDynamicColumnEnabled() && !this.afterAggregate && !this.rewriting && argList.size() == 1) {
                TblColRef srcCol;
                SumDynamicFunctionDesc sumDynFunc;
                int iRowIdx = (Integer)argList.get(0);
                TupleExpression tupleExpr = inputColumnRowType.getSourceColumnsByIndex(iRowIdx);
                if (aggCall.getAggregation() instanceof SqlSumAggFunction || aggCall.getAggregation() instanceof SqlSumEmptyIsZeroAggFunction) {
                    if (!(tupleExpr instanceof NumberTupleExpression) && !(tupleExpr instanceof ColumnTupleExpression)) {
                        ColumnTupleExpression cntExpr = new ColumnTupleExpression(SumDynamicFunctionDesc.mockCntCol);
                        ExpressionCountDistributor cntDistributor = new ExpressionCountDistributor((TupleExpression)cntExpr);
                        tupleExpr = tupleExpr.accept((ExpressionVisitor)cntDistributor);
                        sumDynFunc = new SumDynamicFunctionDesc(parameter, tupleExpr);
                        this.aggregations.add((FunctionDesc)sumDynFunc);
                        continue;
                    }
                } else if (aggCall.getAggregation() instanceof SqlCountAggFunction && !aggCall.isDistinct() && tupleExpr instanceof ColumnTupleExpression && this.context.belongToFactTableDims(srcCol = ((ColumnTupleExpression)tupleExpr).getColumn())) {
                    tupleExpr = this.getCountColumnExpression(srcCol);
                    TblColRef column = TblColRef.newInnerColumn((String)tupleExpr.getDigest(), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
                    sumDynFunc = new SumDynamicFunctionDesc(ParameterDesc.newInstance((Object[])new Object[]{column}), tupleExpr);
                    inputColumnRowType.replaceColumnByIndex(iRowIdx, column, tupleExpr);
                    AggregateCall newAggCall = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.SUM, (boolean)false, (List)aggCall.getArgList(), (int)-1, (RelDataType)aggCall.getType(), (String)aggCall.getName());
                    this.hackAggCalls.put(i, newAggCall);
                    this.context.dynamicFields.put(column, aggCall.getType());
                    this.aggregations.add((FunctionDesc)sumDynFunc);
                    continue;
                }
            }
            String expression = OLAPAggregateRel.getAggrFuncName(aggCall);
            FunctionDesc aggFunc = FunctionDesc.newInstance((String)expression, parameter, null);
            this.aggregations.add(aggFunc);
        }
    }

    public boolean needRewrite() {
        boolean hasRealization = null != this.context.realization;
        return hasRealization && !this.afterAggregate;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        if (this.needRewrite()) {
            this.translateAggregation();
            this.buildRewriteFieldsAndMetricsColumns();
        }
        implementor.visitChild(this, this.getInput());
        this.rewriting = true;
        if (this.needRewrite()) {
            this.rewriteAggCalls = Lists.newArrayListWithExpectedSize((int)this.aggCalls.size());
            for (int i = 0; i < this.aggCalls.size(); ++i) {
                AggregateCall aggCall;
                AggregateCall aggregateCall = aggCall = this.hackAggCalls.get(i) != null ? this.hackAggCalls.get(i) : (AggregateCall)this.aggCalls.get(i);
                if (SqlStdOperatorTable.GROUPING == aggCall.getAggregation()) {
                    this.rewriteAggCalls.add(aggCall);
                    continue;
                }
                FunctionDesc cubeFunc = this.context.aggregations.get(i);
                if (!this.noPrecaculatedFieldsAvailable() || !cubeFunc.needRewriteField()) {
                    if (cubeFunc.needRewrite()) {
                        aggCall = this.rewriteAggregateCall(aggCall, cubeFunc);
                    }
                    if (cubeFunc.getMeasureType() != null && cubeFunc.getMeasureType().needRewriteField()) {
                        aggCall = new KylinAggregateCall(aggCall, cubeFunc);
                    }
                } else {
                    logger.info(aggCall + "skip rewriteAggregateCall because no pre-aggregated field available");
                }
                this.rewriteAggCalls.add(aggCall);
                this.context.aggrSqlCalls.add(this.toSqlCall(aggCall));
            }
        }
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
        this.rewriting = false;
    }

    SQLDigest.SQLCall toSqlCall(AggregateCall aggCall) {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        String function = OLAPAggregateRel.getSqlFuncName(aggCall);
        ArrayList args = Lists.newArrayList();
        for (Integer index : aggCall.getArgList()) {
            TblColRef col = inputColumnRowType.getColumnByIndexNullable(index);
            args.add(col);
        }
        return new SQLDigest.SQLCall(function, (Iterable)args);
    }

    void translateAggregation() {
        if (!this.noPrecaculatedFieldsAvailable()) {
            List measures = this.context.realization.getMeasures();
            ArrayList newAggrs = Lists.newArrayList();
            for (FunctionDesc aggFunc : this.aggregations) {
                if (aggFunc instanceof DynamicFunctionDesc) {
                    DynamicFunctionDesc rtAggFunc = (DynamicFunctionDesc)aggFunc;
                    Map innerOldAggrs = rtAggFunc.getRuntimeFuncMap();
                    HashMap innerNewAggrs = Maps.newHashMapWithExpectedSize((int)innerOldAggrs.size());
                    for (TblColRef key : innerOldAggrs.keySet()) {
                        innerNewAggrs.put(key, this.findInMeasures((FunctionDesc)innerOldAggrs.get(key), measures));
                    }
                    rtAggFunc.setRuntimeFuncMap((Map)innerNewAggrs);
                    newAggrs.add(rtAggFunc);
                    continue;
                }
                newAggrs.add(this.findInMeasures(aggFunc, measures));
            }
            this.aggregations.clear();
            this.aggregations.addAll(newAggrs);
            this.context.aggregations.clear();
            this.context.aggregations.addAll(newAggrs);
        }
    }

    FunctionDesc findInMeasures(FunctionDesc aggFunc, List<MeasureDesc> measures) {
        for (MeasureDesc m : measures) {
            if (!aggFunc.equals((Object)m.getFunction())) continue;
            return m.getFunction();
        }
        return aggFunc;
    }

    void buildRewriteFieldsAndMetricsColumns() {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        for (int i = 0; i < this.aggregations.size(); ++i) {
            AggregateCall aggCall;
            FunctionDesc aggFunc = this.aggregations.get(i);
            if (aggFunc.isDimensionAsMetric()) {
                this.addToContextGroupBy(aggFunc.getParameter().getColRefs());
                continue;
            }
            if (aggFunc.needRewriteField()) {
                String rewriteFieldName = aggFunc.getRewriteFieldName();
                RelDataType rewriteFieldType = OLAPTable.createSqlType(typeFactory, aggFunc.getRewriteFieldType(), true);
                this.context.rewriteFields.put(rewriteFieldName, rewriteFieldType);
                TblColRef column = this.buildRewriteColumn(aggFunc);
                this.context.metricsColumns.add(column);
            }
            if ((aggCall = this.rewriteAggCalls.get(i)).getArgList().isEmpty()) continue;
            for (Integer index : aggCall.getArgList()) {
                TblColRef column = inputColumnRowType.getColumnByIndex(index);
                if (column.isInnerColumn() || !this.context.belongToContextTables(column)) continue;
                this.context.metricsColumns.add(column);
            }
        }
    }

    void addToContextGroupBy(List<TblColRef> colRefs) {
        for (TblColRef col : colRefs) {
            if (col.isInnerColumn() || !this.context.belongToContextTables(col)) continue;
            this.context.groupByColumns.add(col);
        }
    }

    public boolean noPrecaculatedFieldsAvailable() {
        return !this.context.hasPrecalculatedFields() || !OLAPRel.RewriteImplementor.needRewrite(this.context);
    }

    private AggregateCall rewriteAggregateCall(AggregateCall aggCall, FunctionDesc func) {
        String callName = OLAPAggregateRel.getSqlFuncName(aggCall);
        RelDataType fieldType = aggCall.getType();
        SqlAggFunction newAgg = aggCall.getAggregation();
        Map udafMap = func.getMeasureType().getRewriteCalciteAggrFunctions();
        if (func.isCount()) {
            newAgg = SqlStdOperatorTable.SUM0;
        } else if (udafMap != null && udafMap.containsKey(callName)) {
            newAgg = this.createCustomAggFunction(callName, fieldType, (Class)udafMap.get(callName));
        }
        List<Object> newArgList = Lists.newArrayList((Iterable)aggCall.getArgList());
        if (udafMap != null && udafMap.containsKey(callName)) {
            newArgList = this.truncArgList((List<Integer>)newArgList, (Class)udafMap.get(callName));
        }
        if (func.needRewriteField()) {
            RelDataTypeField field = this.getInput().getRowType().getField(func.getRewriteFieldName(), true, false);
            if (newArgList.isEmpty()) {
                newArgList.add(field.getIndex());
            } else {
                newArgList.set(0, field.getIndex());
            }
        }
        AggregateCall newAggCall = new AggregateCall(newAgg, false, (List)newArgList, fieldType, callName);
        return newAggCall;
    }

    List<Integer> truncArgList(List<Integer> argList, Class<?> udafClazz) {
        int argListLength = argList.size();
        for (Method method : udafClazz.getMethods()) {
            if (!method.getName().equals("add")) continue;
            argListLength = Math.min(method.getParameterTypes().length - 1, argListLength);
        }
        return argList.subList(0, argListLength);
    }

    SqlAggFunction createCustomAggFunction(String funcName, RelDataType returnType, Class<?> customAggFuncClz) {
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        SqlIdentifier sqlIdentifier = new SqlIdentifier(funcName, new SqlParserPos(1, 1));
        AggregateFunctionImpl aggFunction = AggregateFunctionImpl.create(customAggFuncClz);
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<Object> typeFamilies = new ArrayList<Object>();
        for (FunctionParameter o : aggFunction.getParameters()) {
            RelDataType type = o.getType(typeFactory);
            argTypes.add(type);
            typeFamilies.add(Util.first((Object)type.getSqlTypeName().getFamily(), (Object)SqlTypeFamily.ANY));
        }
        return new SqlUserDefinedAggFunction(sqlIdentifier, (SqlReturnTypeInference)ReturnTypes.explicit((RelDataType)returnType), InferTypes.explicit(argTypes), (SqlOperandTypeChecker)OperandTypes.family(typeFamilies), (AggregateFunction)aggFunction, false, false, typeFactory);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        try {
            return new EnumerableAggregate(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)OLAPAggregateRel.sole(inputs), this.indicator, this.groupSet, (List)this.groupSets, this.rewriteAggCalls);
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create EnumerableAggregate!", e);
        }
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public List<AggregateCall> getRewriteAggCalls() {
        return this.rewriteAggCalls;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization));
    }

    private TupleExpression getCountColumnExpression(TblColRef colRef) {
        ArrayList whenList = Lists.newArrayListWithExpectedSize((int)1);
        CompareTupleFilter whenFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNULL);
        whenFilter.addChild((TupleFilter)new ColumnTupleFilter(colRef));
        whenList.add(new Pair((Object)whenFilter, (Object)new NumberTupleExpression((Object)0)));
        ColumnTupleExpression elseExpr = new ColumnTupleExpression(SumDynamicFunctionDesc.mockCntCol);
        CaseTupleExpression ret = new CaseTupleExpression((List)whenList, (TupleExpression)elseExpr);
        ret.setDigest("_KY_COUNT(" + colRef.getName() + ")");
        return ret;
    }

    static {
        AGGR_FUNC_MAP.put("SUM", "SUM");
        AGGR_FUNC_MAP.put("$SUM0", "SUM");
        AGGR_FUNC_MAP.put("COUNT", "COUNT");
        AGGR_FUNC_MAP.put("COUNT_DISTINCT", "COUNT_DISTINCT");
        AGGR_FUNC_MAP.put("MAX", "MAX");
        AGGR_FUNC_MAP.put("MIN", "MIN");
        AGGR_FUNC_MAP.put("GROUPING", "GROUPING");
        Map udafFactories = MeasureTypeFactory.getUDAFFactories();
        for (Map.Entry entry : udafFactories.entrySet()) {
            AGGR_FUNC_MAP.put((String)entry.getKey(), ((MeasureTypeFactory)entry.getValue()).getAggrFunctionName());
        }
        Map udafs = MeasureTypeFactory.getUDAFs();
        for (String func : udafs.keySet()) {
            try {
                AGGR_FUNC_PARAM_AS_MEASURE_MAP.put(func, ((ParamAsMeasureCount)((Class)udafs.get(func)).newInstance()).getParamAsMeasureCount());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

