/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.calcite.avatica.InternalProperty;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.kylin.common.HotLoadKylinPropertiesTestCase;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.QueryConnection;
import org.junit.Assert;
import org.junit.Test;

public class QueryConnectionTest
extends HotLoadKylinPropertiesTestCase {
    private static final String SQL_WITH_MIXED_CASE = "select 1 as value_ALIAS";

    @Test
    public void testGetConnection() throws SQLException, IllegalAccessException {
        Connection connection = QueryConnection.getConnection((String)"default");
        Assert.assertNotNull((Object)connection);
        Map<InternalProperty, Object> properties = QueryConnectionTest.dirtyReadProperties(connection);
        Assert.assertEquals((Object)true, (Object)properties.get(InternalProperty.CASE_SENSITIVE));
        Assert.assertEquals((Object)Casing.TO_UPPER, (Object)properties.get(InternalProperty.UNQUOTED_CASING));
        Assert.assertEquals((Object)Quoting.DOUBLE_QUOTE, (Object)properties.get(InternalProperty.QUOTING));
        ResultSet resultSet = connection.prepareStatement(SQL_WITH_MIXED_CASE).executeQuery();
        String columnName = resultSet.getMetaData().getColumnName(1);
        Assert.assertEquals((Object)"VALUE_ALIAS", (Object)columnName);
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        conf.setProperty("kylin.query.calcite.extras-props.caseSensitive", "false");
        conf.setProperty("kylin.query.calcite.extras-props.unquotedCasing", "UNCHANGED");
        conf.setProperty("kylin.query.calcite.extras-props.quoting", "BRACKET");
        Connection conn2 = QueryConnection.getConnection((String)"default");
        Map<InternalProperty, Object> props = QueryConnectionTest.dirtyReadProperties(conn2);
        Assert.assertEquals((Object)false, (Object)props.get(InternalProperty.CASE_SENSITIVE));
        Assert.assertEquals((Object)Casing.UNCHANGED, (Object)props.get(InternalProperty.UNQUOTED_CASING));
        Assert.assertEquals((Object)Quoting.BRACKET, (Object)props.get(InternalProperty.QUOTING));
        ResultSet resultSet1 = conn2.prepareStatement(SQL_WITH_MIXED_CASE).executeQuery();
        Assert.assertEquals((Object)"value_ALIAS", (Object)resultSet1.getMetaData().getColumnName(1));
    }

    private static Map<InternalProperty, Object> dirtyReadProperties(Connection connection) throws IllegalAccessException {
        Assert.assertTrue((boolean)(connection instanceof CalciteConnection));
        return (Map)FieldUtils.readField((Object)connection, (String)"properties");
    }
}

