/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.routing.RealizationChooser;
import org.apache.kylin.query.security.QueryInterceptor;
import org.apache.kylin.query.security.QueryInterceptorUtil;

public class OLAPToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    public OLAPToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new OLAPToEnumerableConverter(this.getCluster(), traitSet, (RelNode)OLAPToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor enumImplementor, EnumerableRel.Prefer pref) {
        if (System.getProperty("calcite.debug") != null) {
            String dumpPlan = RelOptUtil.dumpPlan((String)"", (RelNode)this, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            System.out.println("EXECUTION PLAN BEFORE REWRITE");
            System.out.println(dumpPlan);
        }
        OLAPRel.OLAPImplementor olapImplementor = new OLAPRel.OLAPImplementor();
        olapImplementor.visitChild(this.getInput(), (RelNode)this);
        List<OLAPContext> contexts = this.listContextsHavingScan();
        if (contexts.size() > 0) {
            List<QueryInterceptor> intercepts = QueryInterceptorUtil.getQueryInterceptors();
            for (QueryInterceptor intercept : intercepts) {
                intercept.intercept(contexts);
            }
        }
        if (System.getProperty("calcite.debug") != null) {
            String dumpPlan = RelOptUtil.dumpPlan((String)"", (RelNode)this, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            System.out.println("EXECUTION PLAN AFTER OLAPCONTEXT IS SET");
            System.out.println(dumpPlan);
        }
        RealizationChooser.selectRealization(contexts);
        this.doAccessControl(contexts);
        OLAPRel.RewriteImplementor rewriteImplementor = new OLAPRel.RewriteImplementor();
        rewriteImplementor.visitChild((RelNode)this, this.getInput());
        OLAPRel.JavaImplementor impl = new OLAPRel.JavaImplementor(enumImplementor);
        EnumerableRel inputAsEnum = impl.createEnumerable((OLAPRel)this.getInput());
        this.replaceInput(0, (RelNode)inputAsEnum);
        if (System.getProperty("calcite.debug") != null) {
            String dumpPlan = RelOptUtil.dumpPlan((String)"", (RelNode)this, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            System.out.println("EXECUTION PLAN AFTER REWRITE");
            System.out.println(dumpPlan);
            QueryContextFacade.current().setCalcitePlan((Object)this.copy(this.getTraitSet(), this.getInputs()));
        }
        return impl.visitChild(this, 0, inputAsEnum, pref);
    }

    protected List<OLAPContext> listContextsHavingScan() {
        int size = OLAPContext.getThreadLocalContexts().size();
        ArrayList result = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            OLAPContext ctx = OLAPContext.getThreadLocalContextById(i);
            if (ctx.firstTableScan == null) continue;
            result.add(ctx);
        }
        return result;
    }

    protected void doAccessControl(List<OLAPContext> contexts) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String controllerCls = config.getQueryAccessController();
        if (null != controllerCls && !controllerCls.isEmpty()) {
            OLAPContext.IAccessController accessController = (OLAPContext.IAccessController)ClassUtil.newInstance((String)controllerCls);
            accessController.check(contexts, config);
        }
    }
}

