/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.query.util.QueryUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryUtilTest
extends LocalFileMetadataTestCase {
    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testMassageSql() {
        String sql = "select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        String s = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select ( date '2001-09-28' + interval '1' day) from test_kylin_fact", (Object)s);
        sql = "select ( date '2001-09-28' + interval floor(2) month) from test_kylin_fact group by ( date '2001-09-28' + interval floor(2) month)";
        s = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select ( date '2001-09-28' + interval '2' month) from test_kylin_fact group by ( date '2001-09-28' + interval '2' month)", (Object)s);
        sql = "select count(*) test_limit from test_kylin_fact where price > 10.0";
        s = QueryUtil.massageSql((String)sql, (String)"default", (int)50000, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select count(*) test_limit from test_kylin_fact where price > 10.0\nLIMIT 50000", (Object)s);
        sql = "select count(*) test_offset from test_kylin_fact where price > 10.0";
        s = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)50, (String)"DEFAULT");
        Assert.assertEquals((Object)"select count(*) test_offset from test_kylin_fact where price > 10.0\nOFFSET 50", (Object)s);
        sql = "select count(*) test_limit_and_offset from test_kylin_fact where price > 10.0";
        s = QueryUtil.massageSql((String)sql, (String)"default", (int)50000, (int)50, (String)"DEFAULT");
        Assert.assertEquals((Object)"select count(*) test_limit_and_offset from test_kylin_fact where price > 10.0\nLIMIT 50000\nOFFSET 50", (Object)s);
        String newLine = System.getProperty("line.separator");
        String sql2 = "select count(*)     test_limit from " + newLine + "test_kylin_fact where price > 10.0";
        newLine = newLine.replace("\r", " ").replace("\n", newLine);
        String s2 = QueryUtil.massageSql((String)sql2, (String)"default", (int)50000, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)("select count(*)     test_limit from " + newLine + "test_kylin_fact where price > 10.0\nLIMIT 50000"), (Object)s2);
        newLine = System.getProperty("line.separator");
        sql2 = "select count(*)     test_offset from " + newLine + "test_kylin_fact where price > 10.0";
        newLine = newLine.replace("\r", " ").replace("\n", newLine);
        s2 = QueryUtil.massageSql((String)sql2, (String)"default", (int)50000, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)("select count(*)     test_offset from " + newLine + "test_kylin_fact where price > 10.0\nLIMIT 50000"), (Object)s2);
        newLine = System.getProperty("line.separator");
        sql2 = "select count(*)     test_limit_and_offset from " + newLine + "test_kylin_fact where price > 10.0";
        newLine = newLine.replace("\r", " ").replace("\n", newLine);
        s2 = QueryUtil.massageSql((String)sql2, (String)"default", (int)50000, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)("select count(*)     test_limit_and_offset from " + newLine + "test_kylin_fact where price > 10.0\nLIMIT 50000"), (Object)s2);
    }

    @Test
    public void testIsSelect() {
        String sql = "select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        boolean selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
        sql = " Select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
        sql = " \nSelect ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
        sql = "--comment\n /* comment */Select ( date '2001-09-28' + interval floor(1.2) day) from test_kylin_fact";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
        sql = " UPDATE Customers\nSET ContactName = 'Alfred Schmidt', City= 'Frankfurt'\nWHERE CustomerID = 1;";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)false, (Object)selectStatement);
        sql = " explain plan for select count(*) from test_kylin_fact\n";
        selectStatement = QueryUtil.isSelectStatement((String)sql);
        Assert.assertEquals((Object)true, (Object)selectStatement);
    }

    @Test
    public void testKeywordDefaultDirtyHack() {
        KylinConfig.getInstanceFromEnv().setProperty("kylin.query.escape-default-keyword", "true");
        String sql = "select * from DEFAULT.TEST_KYLIN_FACT";
        String s = QueryUtil.massageSql((String)sql, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select * from \"DEFAULT\".TEST_KYLIN_FACT", (Object)s);
    }

    @Test
    public void testForceLimit() {
        KylinConfig.getInstanceFromEnv().setProperty("kylin.query.force-limit", "10");
        String sql1 = "select   * \nfrom DEFAULT.TEST_KYLIN_FACT";
        String result = QueryUtil.massageSql((String)sql1, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select   * \nfrom DEFAULT.TEST_KYLIN_FACT\nLIMIT 10", (Object)result);
        String sql2 = "select   2 * 8 from DEFAULT.TEST_KYLIN_FACT";
        result = QueryUtil.massageSql((String)sql2, (String)"default", (int)0, (int)0, (String)"DEFAULT");
        Assert.assertEquals((Object)"select   2 * 8 from DEFAULT.TEST_KYLIN_FACT", (Object)result);
    }

    @Test
    public void testRemoveCommentInSql() {
        String originSql = "select count(*) from test_kylin_fact where price > 10.0";
        String sqlWithComment = "-- comment \n" + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "-- comment \n -- comment\n" + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "-- \n -- comment \n" + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = originSql + "-- \n -- comment \n";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "-- \n -- comment \n" + originSql + "-- \n -- comment \n";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment */ " + originSql + "-- \n -- comment \n";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1/comment2 */ " + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1 * comment2 */ " + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1 * comment2 */ /* comment3 / comment4 */ -- comment 5\n" + originSql;
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1 * \ncomment2 */ -- comment 5\n" + originSql + "/* comment3 / comment4 */";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
        sqlWithComment = "/* comment1 * \ncomment2 */ -- comment 3\n" + originSql + "-- comment 5";
        Assert.assertEquals((Object)originSql, (Object)QueryUtil.removeCommentInSql((String)sqlWithComment));
    }
}

