/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.RoutingIndicatorException;
import org.apache.kylin.source.adhocquery.IPushDownConverter;
import org.apache.kylin.source.adhocquery.IPushDownRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownUtil {
    private static final Logger logger = LoggerFactory.getLogger(PushDownUtil.class);

    public static Pair<List<List<String>>, List<SelectedColumnMeta>> tryPushDownSelectQuery(String project, String sql, String defaultSchema, SQLException sqlException, boolean isPrepare) throws Exception {
        return PushDownUtil.tryPushDownQuery(project, sql, defaultSchema, sqlException, true, isPrepare);
    }

    public static Pair<List<List<String>>, List<SelectedColumnMeta>> tryPushDownNonSelectQuery(String project, String sql, String defaultSchema, boolean isPrepare) throws Exception {
        return PushDownUtil.tryPushDownQuery(project, sql, defaultSchema, null, false, isPrepare);
    }

    private static Pair<List<List<String>>, List<SelectedColumnMeta>> tryPushDownQuery(String project, String sql, String defaultSchema, SQLException sqlException, boolean isSelect, boolean isPrepare) throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!kylinConfig.isPushDownEnabled()) {
            return null;
        }
        if (isSelect) {
            logger.info("Query failed to utilize pre-calculation, routing to other engines", (Throwable)sqlException);
            if (!PushDownUtil.isExpectedCause(sqlException)) {
                logger.info("quit doPushDownQuery because prior exception thrown is unexpected");
                return null;
            }
        } else {
            Preconditions.checkState((sqlException == null ? 1 : 0) != 0);
            logger.info("Kylin cannot support non-select queries, routing to other engines");
        }
        IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance((String)kylinConfig.getPushDownRunnerClassName());
        runner.init(kylinConfig);
        logger.debug("Query Pushdown runner {}", (Object)runner);
        if (defaultSchema != null && !defaultSchema.equals("DEFAULT")) {
            String completed = sql;
            try {
                completed = PushDownUtil.schemaCompletion(sql, defaultSchema);
            }
            catch (SqlParseException e) {
                logger.debug("fail to do schema completion on the pushdown sql, ignore it.", (Object)e.getMessage());
            }
            if (!sql.equals(completed)) {
                logger.info("the query is converted to {} after schema completion", (Object)completed);
                sql = completed;
            }
        }
        for (String converterName : kylinConfig.getPushDownConverterClassNames()) {
            IPushDownConverter converter = (IPushDownConverter)ClassUtil.newInstance((String)converterName);
            String converted = converter.convert(sql, project, defaultSchema, isPrepare);
            if (sql.equals(converted)) continue;
            logger.info("the query is converted to {} after applying converter {}", (Object)converted, (Object)converterName);
            sql = converted;
        }
        ArrayList returnRows = Lists.newArrayList();
        ArrayList returnColumnMeta = Lists.newArrayList();
        if (isSelect) {
            runner.executeQuery(sql, (List)returnRows, (List)returnColumnMeta);
        }
        if (!isSelect && !isPrepare && kylinConfig.isPushDownUpdateEnabled()) {
            runner.executeUpdate(sql);
        }
        return Pair.newPair((Object)returnRows, (Object)returnColumnMeta);
    }

    private static boolean isExpectedCause(SQLException sqlException) {
        Preconditions.checkArgument((sqlException != null ? 1 : 0) != 0);
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)sqlException);
        boolean isPushDownUpdateEnabled = KylinConfig.getInstanceFromEnv().isPushDownUpdateEnabled();
        if (!isPushDownUpdateEnabled) {
            return rootCause != null && (rootCause instanceof NoRealizationFoundException || rootCause instanceof RoutingIndicatorException);
        }
        return rootCause != null && (rootCause instanceof NoRealizationFoundException || rootCause instanceof SqlValidatorException || rootCause instanceof RoutingIndicatorException);
    }

    static String schemaCompletion(String inputSql, String schema) throws SqlParseException {
        if (inputSql == null || inputSql.equals("")) {
            return "";
        }
        SqlNode node = CalciteParser.parse((String)inputSql);
        FromTablesVisitor ftv = new FromTablesVisitor();
        node.accept((SqlVisitor)ftv);
        List<SqlNode> tablesWithoutSchema = ftv.getTablesWithoutSchema();
        if (tablesWithoutSchema.isEmpty()) {
            return inputSql;
        }
        ArrayList<Pair> tablesPos = new ArrayList<Pair>();
        for (SqlNode tables : tablesWithoutSchema) {
            tablesPos.add(CalciteParser.getReplacePos((SqlNode)tables, (String)inputSql));
        }
        Collections.sort(tablesPos, new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                int r = (Integer)o2.getFirst() - (Integer)o1.getFirst();
                return r == 0 ? (Integer)o2.getSecond() - (Integer)o1.getSecond() : r;
            }
        });
        StrBuilder afterConvert = new StrBuilder(inputSql);
        for (Pair pos : tablesPos) {
            String tableWithSchema = schema + "." + inputSql.substring((Integer)pos.getFirst(), (Integer)pos.getSecond());
            afterConvert.replace(((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), tableWithSchema);
        }
        return afterConvert.toString();
    }

    static class FromTablesVisitor
    implements SqlVisitor<SqlNode> {
        private List<SqlNode> tables = new ArrayList<SqlNode>();

        FromTablesVisitor() {
        }

        List<SqlNode> getTablesWithoutSchema() {
            return this.tables;
        }

        public SqlNode visit(SqlNodeList nodeList) {
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode node = nodeList.get(i);
                if (!(node instanceof SqlWithItem)) continue;
                SqlWithItem item = (SqlWithItem)node;
                item.query.accept((SqlVisitor)this);
            }
            return null;
        }

        public SqlNode visit(SqlLiteral literal) {
            return null;
        }

        public SqlNode visit(SqlCall call) {
            SqlBasicCall node;
            if (call instanceof SqlSelect) {
                SqlSelect select = (SqlSelect)call;
                select.getFrom().accept((SqlVisitor)this);
                return null;
            }
            if (call instanceof SqlOrderBy) {
                SqlOrderBy orderBy = (SqlOrderBy)call;
                orderBy.query.accept((SqlVisitor)this);
                return null;
            }
            if (call instanceof SqlWith) {
                SqlWith sqlWith = (SqlWith)call;
                sqlWith.body.accept((SqlVisitor)this);
                sqlWith.withList.accept((SqlVisitor)this);
            }
            if (call instanceof SqlBasicCall) {
                node = (SqlBasicCall)call;
                node.getOperands()[0].accept((SqlVisitor)this);
                return null;
            }
            if (call instanceof SqlJoin) {
                node = (SqlJoin)call;
                node.getLeft().accept((SqlVisitor)this);
                node.getRight().accept((SqlVisitor)this);
                return null;
            }
            return null;
        }

        public SqlNode visit(SqlIdentifier id) {
            if (id.names.size() == 1) {
                this.tables.add((SqlNode)id);
            }
            return null;
        }

        public SqlNode visit(SqlDataTypeSpec type) {
            return null;
        }

        public SqlNode visit(SqlDynamicParam param) {
            return null;
        }

        public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
            return null;
        }
    }
}

