/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.OLAPContext;

public class TableLevelACL {
    public static void tableFilter(List<OLAPContext> contexts, List<String> tableBlackList) {
        Set<String> tableWithSchema = TableLevelACL.getTableWithSchema(contexts);
        for (String tbl : tableBlackList) {
            if (!tableWithSchema.contains(tbl.toUpperCase())) continue;
            System.out.println("Access table:" + tbl + " denied");
        }
    }

    public static void columnFilter(List<OLAPContext> contexts, List<String> columnBlackList) {
        List<String> allColWithTblAndSchema = TableLevelACL.getAllColWithTblAndSchema(contexts);
        for (String tbl : columnBlackList) {
            if (!allColWithTblAndSchema.contains(tbl.toUpperCase())) continue;
            System.out.println("Access table:" + tbl + " denied");
        }
    }

    public static List<String> getAllColWithTblAndSchema(List<OLAPContext> contexts) {
        ArrayList<String> allColWithTblAndSchema = new ArrayList<String>();
        for (OLAPContext context : contexts) {
            Set<TblColRef> allColumns = context.allColumns;
            for (TblColRef tblColRef : allColumns) {
                allColWithTblAndSchema.add(tblColRef.getColumWithTableAndSchema());
            }
        }
        return allColWithTblAndSchema;
    }

    public static Set<String> getTableWithSchema(List<OLAPContext> contexts) {
        HashSet<String> tableWithSchema = new HashSet<String>();
        for (OLAPContext context : contexts) {
            Set<TblColRef> allColumns = context.allColumns;
            for (TblColRef tblColRef : allColumns) {
                tableWithSchema.add(tblColRef.getTableWithSchema());
            }
        }
        return tableWithSchema;
    }

    public static List<String> mockTableBlackList() {
        ArrayList<String> blackList = new ArrayList<String>();
        blackList.add("DEFAULT.KYLIN_SALES");
        return blackList;
    }
}

