/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.security;

import java.util.Collection;
import java.util.List;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.security.AccessDeniedException;

public abstract class QueryInterceptor {
    public void intercept(List<OLAPContext> contexts) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<String> userIdentifierBlackList = this.getIdentifierBlackList(contexts);
        this.intercept(contexts, userIdentifierBlackList);
    }

    private void intercept(List<OLAPContext> contexts, Collection<String> blackList) {
        if (blackList.isEmpty()) {
            return;
        }
        Collection<String> queryCols = this.getQueryIdentifiers(contexts);
        for (String id : blackList) {
            if (!queryCols.contains(id.toUpperCase())) continue;
            throw new AccessDeniedException(this.getIdentifierType() + ":" + id);
        }
    }

    protected abstract boolean isEnabled();

    protected abstract Collection<String> getQueryIdentifiers(List<OLAPContext> var1);

    protected abstract Collection<String> getIdentifierBlackList(List<OLAPContext> var1);

    protected abstract String getIdentifierType();

    protected String getProject(List<OLAPContext> contexts) {
        return contexts.get((int)0).olapSchema.getProjectName();
    }

    protected String getUser(List<OLAPContext> contexts) {
        return contexts.get((int)0).olapAuthen.getUsername();
    }
}

