/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.metadata.model.DatabaseDesc;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.query.schema.OLAPSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPSchemaFactory
implements SchemaFactory {
    public static final Logger logger = LoggerFactory.getLogger(OLAPSchemaFactory.class);
    private static final String SCHEMA_PROJECT = "project";
    private static Map<String, File> cachedJsons = Maps.newConcurrentMap();

    public Schema create(SchemaPlus parentSchema, String schemaName, Map<String, Object> operand) {
        String project = (String)operand.get(SCHEMA_PROJECT);
        OLAPSchema newSchema = new OLAPSchema(project, schemaName, OLAPSchemaFactory.exposeMore());
        return newSchema;
    }

    public static boolean exposeMore() {
        return KylinConfig.getInstanceFromEnv().isPushDownEnabled();
    }

    public static File createTempOLAPJson(String project, KylinConfig config) {
        Collection tables = ProjectManager.getInstance((KylinConfig)config).listExposedTables(project, OLAPSchemaFactory.exposeMore());
        HashMap schemaCounts = DatabaseDesc.extractDatabaseOccurenceCounts((Collection)tables);
        String majoritySchemaName = "";
        int majoritySchemaCount = 0;
        for (Map.Entry e : schemaCounts.entrySet()) {
            if (((String)e.getKey()).equalsIgnoreCase("default")) {
                majoritySchemaCount = Integer.MAX_VALUE;
                majoritySchemaName = (String)e.getKey();
            }
            if ((Integer)e.getValue() < majoritySchemaCount) continue;
            majoritySchemaCount = (Integer)e.getValue();
            majoritySchemaName = (String)e.getKey();
        }
        try {
            StringBuilder out = new StringBuilder();
            out.append("{\n");
            out.append("    \"version\": \"1.0\",\n");
            out.append("    \"defaultSchema\": \"" + majoritySchemaName + "\",\n");
            out.append("    \"schemas\": [\n");
            int counter = 0;
            for (String schemaName : schemaCounts.keySet()) {
                out.append("        {\n");
                out.append("            \"type\": \"custom\",\n");
                out.append("            \"name\": \"" + schemaName + "\",\n");
                out.append("            \"factory\": \"" + KylinConfig.getInstanceFromEnv().getSchemaFactory() + "\",\n");
                out.append("            \"operand\": {\n");
                out.append("                \"project\": \"" + project + "\"\n");
                out.append("            },\n");
                OLAPSchemaFactory.createOLAPSchemaFunctions(out);
                out.append("        }\n");
                if (++counter == schemaCounts.size()) continue;
                out.append(",\n");
            }
            out.append("    ]\n");
            out.append("}\n");
            String jsonContent = out.toString();
            File file = cachedJsons.get(jsonContent);
            if (file == null) {
                file = File.createTempFile("olap_model_", ".json");
                file.deleteOnExit();
                FileUtils.writeStringToFile((File)file, (String)jsonContent);
                logger.debug("Adding new schema file {} to cache", (Object)file.getName());
                logger.debug("Schema json: " + jsonContent);
                cachedJsons.put(jsonContent, file);
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createOLAPSchemaFunctions(StringBuilder out) throws IOException {
        HashMap udfs = Maps.newHashMap();
        udfs.putAll(KylinConfig.getInstanceFromEnv().getUDFs());
        for (Map.Entry entry : MeasureTypeFactory.getUDAFs().entrySet()) {
            udfs.put(entry.getKey(), ((Class)entry.getValue()).getName());
        }
        int index = 0;
        out.append("            \"functions\": [\n");
        for (Map.Entry udf : udfs.entrySet()) {
            String udfName = ((String)udf.getKey()).trim().toUpperCase();
            String udfClassName = ((String)udf.getValue()).trim();
            out.append("               {\n");
            out.append("                   name: '" + udfName + "',\n");
            out.append("                   className: '" + udfClassName + "'\n");
            if (index < udfs.size() - 1) {
                out.append("               },\n");
            } else {
                out.append("               }\n");
            }
            ++index;
        }
        out.append("            ]\n");
    }
}

