/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import java.util.Arrays;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.shaded.htrace.org.apache.htrace.Trace;
import org.apache.kylin.shaded.htrace.org.apache.htrace.TraceScope;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.StorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPEnumerator
implements Enumerator<Object[]> {
    private static final Logger logger = LoggerFactory.getLogger(OLAPEnumerator.class);
    private final OLAPContext olapContext;
    private final DataContext optiqContext;
    private Object[] current;
    private ITupleIterator cursor;

    public OLAPEnumerator(OLAPContext olapContext, DataContext optiqContext) {
        this.olapContext = olapContext;
        this.optiqContext = optiqContext;
        this.cursor = null;
    }

    public Object[] current() {
        return this.current;
    }

    public boolean moveNext() {
        try {
            if (this.cursor == null) {
                this.cursor = this.queryStorage();
            }
            if (!this.cursor.hasNext()) {
                return false;
            }
            ITuple tuple = (ITuple)this.cursor.next();
            if (tuple == null) {
                return false;
            }
            this.convertCurrentRow(tuple);
            return true;
        }
        catch (Exception e) {
            try {
                if (this.cursor != null) {
                    this.cursor.close();
                }
            }
            catch (Exception ee) {
                logger.info("Error when closing cursor, ignore it", (Throwable)ee);
            }
            throw e;
        }
    }

    private void convertCurrentRow(ITuple tuple) {
        Object[] values = tuple.getAllValues();
        this.current = Arrays.copyOf(values, values.length);
    }

    public void reset() {
        this.close();
        this.cursor = this.queryStorage();
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    private ITupleIterator queryStorage() {
        try (TraceScope scope = Trace.startSpan((String)("query realization " + this.olapContext.realization.getCanonicalName()));){
            logger.debug("query storage...");
            this.olapContext.bindVariable(this.optiqContext);
            this.olapContext.resetSQLDigest();
            SQLDigest sqlDigest = this.olapContext.getSQLDigest();
            IStorageQuery storageEngine = StorageFactory.createQuery((IRealization)this.olapContext.realization);
            ITupleIterator iterator = storageEngine.search(this.olapContext.storageContext, sqlDigest, this.olapContext.returnTupleInfo);
            if (logger.isDebugEnabled()) {
                logger.debug("return TupleIterator...");
            }
            ITupleIterator iTupleIterator = iterator;
            return iTupleIterator;
        }
    }
}

