/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.adhoc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.kylin.common.KylinConfig;

public class JdbcPushDownConnectionManager {
    private static volatile JdbcPushDownConnectionManager manager = null;
    private final BasicDataSource dataSource = new BasicDataSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static JdbcPushDownConnectionManager getConnectionManager() throws ClassNotFoundException {
        if (manager != null) return manager;
        Class<JdbcPushDownConnectionManager> clazz = JdbcPushDownConnectionManager.class;
        synchronized (JdbcPushDownConnectionManager.class) {
            if (manager != null) return manager;
            manager = new JdbcPushDownConnectionManager(KylinConfig.getInstanceFromEnv());
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private JdbcPushDownConnectionManager(KylinConfig config) throws ClassNotFoundException {
        Class.forName(config.getJdbcDriverClass());
        this.dataSource.setDriverClassName(config.getJdbcDriverClass());
        this.dataSource.setUrl(config.getJdbcUrl());
        this.dataSource.setUsername(config.getJdbcUsername());
        this.dataSource.setPassword(config.getJdbcPassword());
        this.dataSource.setMaxActive(config.getPoolMaxTotal());
        this.dataSource.setMaxIdle(config.getPoolMaxIdle());
        this.dataSource.setMinIdle(config.getPoolMinIdle());
        this.dataSource.setTestOnBorrow(true);
        this.dataSource.setValidationQuery("select 1");
        this.dataSource.setRemoveAbandoned(true);
        this.dataSource.setRemoveAbandonedTimeout(300);
    }

    public void close() {
        try {
            this.dataSource.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

