/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.aggregate;

import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.measure.dim.DimCountDistinctAggFunc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DimCountDistinctAggFuncTest
extends LocalFileMetadataTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testBasic() {
        DimCountDistinctAggFunc.DimDistinctCounter counter = DimCountDistinctAggFunc.init();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 2; ++j) {
                counter = DimCountDistinctAggFunc.add((DimCountDistinctAggFunc.DimDistinctCounter)counter, (Object)i);
                counter = DimCountDistinctAggFunc.add((DimCountDistinctAggFunc.DimDistinctCounter)counter, (Object)i);
                counter = DimCountDistinctAggFunc.add((DimCountDistinctAggFunc.DimDistinctCounter)counter, (Object)Character.valueOf((char)i));
                counter = DimCountDistinctAggFunc.add((DimCountDistinctAggFunc.DimDistinctCounter)counter, (Object)Integer.toString(i));
            }
        }
        Assert.assertEquals((long)40L, (long)DimCountDistinctAggFunc.result((DimCountDistinctAggFunc.DimDistinctCounter)counter));
    }

    @Test
    public void testEmpty() {
        DimCountDistinctAggFunc.DimDistinctCounter counter = DimCountDistinctAggFunc.init();
        Assert.assertEquals((long)0L, (long)DimCountDistinctAggFunc.result((DimCountDistinctAggFunc.DimDistinctCounter)counter));
    }

    @Test
    public void testThreshold() {
        System.setProperty("kylin.query.dim.distinct.max", "100");
        DimCountDistinctAggFunc.DimDistinctCounter counter = DimCountDistinctAggFunc.init();
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Cardinality of dimension exceeds the threshold: 100");
        for (int i = 0; i < 200; ++i) {
            counter = DimCountDistinctAggFunc.add((DimCountDistinctAggFunc.DimDistinctCounter)counter, (Object)i);
        }
        System.clearProperty("kylin.query.dim.distinct.max");
    }
}

