/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.NoRealizationFoundException;
import org.apache.kylin.query.routing.RoutingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRouter {
    private static final Logger logger = LoggerFactory.getLogger(QueryRouter.class);

    public static IRealization selectRealization(OLAPContext olapContext) throws NoRealizationFoundException {
        ProjectManager prjMgr = ProjectManager.getInstance((KylinConfig)olapContext.olapSchema.getConfig());
        logger.info("The project manager's reference is " + prjMgr);
        String factTableName = olapContext.firstTableScan.getTableName();
        String projectName = olapContext.olapSchema.getProjectName();
        Set realizations = prjMgr.getRealizationsByTable(projectName, factTableName);
        SQLDigest sqlDigest = olapContext.getSQLDigest();
        ArrayList candidates = Lists.newArrayListWithCapacity((int)realizations.size());
        for (IRealization real : realizations) {
            if (!real.isReady()) continue;
            candidates.add(new Candidate(real, sqlDigest));
        }
        logger.info("Find candidates by table " + factTableName + " and project=" + projectName + " : " + StringUtils.join((Iterable)candidates, (String)","));
        RoutingRule.applyRules(candidates);
        if (candidates.size() == 0) {
            throw new NoRealizationFoundException("Can't find any realization. Please confirm with providers. SQL digest: " + sqlDigest.toString());
        }
        Candidate chosen = (Candidate)candidates.get(0);
        QueryRouter.adjustForDimensionAsMeasure(chosen, olapContext);
        logger.info("The realizations remaining: " + RoutingRule.getPrintableText(candidates) + " And the final chosen one is the first one");
        return chosen.realization;
    }

    private static void adjustForDimensionAsMeasure(Candidate chosen, OLAPContext olapContext) {
        CapabilityResult capability = chosen.getCapability();
        for (CapabilityResult.CapabilityInfluence inf : capability.influences) {
            if (!(inf instanceof CapabilityResult.DimensionAsMeasure)) continue;
            FunctionDesc functionDesc = ((CapabilityResult.DimensionAsMeasure)inf).getMeasureFunction();
            functionDesc.setDimensionAsMetric(true);
            logger.info("Adjust DimensionAsMeasure for " + functionDesc);
        }
    }
}

