/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.schema.OLAPSchema;
import org.apache.kylin.storage.StorageContext;

public class OLAPContext {
    public static final String PRM_ACCEPT_PARTIAL_RESULT = "AcceptPartialResult";
    private static final ThreadLocal<Map<String, String>> _localPrarameters = new ThreadLocal();
    private static final ThreadLocal<Map<Integer, OLAPContext>> _localContexts = new ThreadLocal();
    public final int id;
    public final StorageContext storageContext;
    public OLAPSchema olapSchema = null;
    public OLAPTableScan firstTableScan = null;
    public TupleInfo returnTupleInfo = null;
    public boolean afterAggregate = false;
    public boolean afterSkippedFilter = false;
    public boolean afterJoin = false;
    public boolean hasJoin = false;
    public IRealization realization;
    public Collection<TblColRef> allColumns = new HashSet<TblColRef>();
    public Collection<TblColRef> groupByColumns = new ArrayList<TblColRef>();
    public Collection<TblColRef> metricsColumns = new HashSet<TblColRef>();
    public List<FunctionDesc> aggregations = new ArrayList<FunctionDesc>();
    public Collection<TblColRef> filterColumns = new HashSet<TblColRef>();
    public TupleFilter filter;
    public List<JoinDesc> joins = new LinkedList<JoinDesc>();
    private List<MeasureDesc> sortMeasures;
    private List<SQLDigest.OrderEnum> sortOrders;
    public Map<String, RelDataType> rewriteFields = new HashMap<String, RelDataType>();
    public int limit;
    public String sql = "";
    private SQLDigest sqlDigest;

    public static void setParameters(Map<String, String> parameters) {
        _localPrarameters.set(parameters);
    }

    public static void clearParameter() {
        _localPrarameters.remove();
    }

    public static void registerContext(OLAPContext ctx) {
        if (_localContexts.get() == null) {
            HashMap contextMap = new HashMap();
            _localContexts.set(contextMap);
        }
        _localContexts.get().put(ctx.id, ctx);
    }

    public static Collection<OLAPContext> getThreadLocalContexts() {
        Map<Integer, OLAPContext> map = _localContexts.get();
        return map == null ? null : map.values();
    }

    public static OLAPContext getThreadLocalContextById(int id) {
        Map<Integer, OLAPContext> map = _localContexts.get();
        return map.get(id);
    }

    public static void clearThreadLocalContexts() {
        _localContexts.remove();
    }

    public OLAPContext(int seq) {
        String acceptPartialResult;
        this.id = seq;
        this.storageContext = new StorageContext();
        this.sortMeasures = Lists.newArrayList();
        this.sortOrders = Lists.newArrayList();
        Map<String, String> parameters = _localPrarameters.get();
        if (parameters != null && (acceptPartialResult = parameters.get(PRM_ACCEPT_PARTIAL_RESULT)) != null) {
            this.storageContext.setAcceptPartialResult(Boolean.parseBoolean(acceptPartialResult));
        }
    }

    public boolean isSimpleQuery() {
        return this.joins.size() == 0 && this.groupByColumns.size() == 0 && this.aggregations.size() == 0;
    }

    public SQLDigest getSQLDigest() {
        if (this.sqlDigest == null) {
            this.sqlDigest = new SQLDigest(this.firstTableScan.getTableName(), this.filter, this.joins, this.allColumns, this.groupByColumns, this.filterColumns, this.metricsColumns, this.aggregations, this.sortMeasures, this.sortOrders);
        }
        return this.sqlDigest;
    }

    public void resetSQLDigest() {
        this.sqlDigest = null;
    }

    public void setReturnTupleInfo(RelDataType rowType, ColumnRowType columnRowType) {
        TupleInfo info = new TupleInfo();
        List fieldList = rowType.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            RelDataTypeField field = (RelDataTypeField)fieldList.get(i);
            TblColRef col = columnRowType == null ? null : columnRowType.getColumnByIndex(i);
            info.setField(field.getName(), col, i);
        }
        this.returnTupleInfo = info;
    }

    public void addSort(MeasureDesc measure, SQLDigest.OrderEnum order) {
        if (measure != null) {
            this.sortMeasures.add(measure);
            this.sortOrders.add(order);
        }
    }
}

