/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import java.util.Map;
import java.util.Properties;
import org.apache.calcite.DataContext;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.StorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPEnumerator
implements Enumerator<Object[]> {
    private static final Logger logger = LoggerFactory.getLogger(OLAPEnumerator.class);
    private final OLAPContext olapContext;
    private final DataContext optiqContext;
    private Object[] current;
    private ITupleIterator cursor;

    public OLAPEnumerator(OLAPContext olapContext, DataContext optiqContext) {
        this.olapContext = olapContext;
        this.optiqContext = optiqContext;
        this.cursor = null;
    }

    public Object[] current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.cursor == null) {
            this.cursor = this.queryStorage();
        }
        if (!this.cursor.hasNext()) {
            return false;
        }
        ITuple tuple = (ITuple)this.cursor.next();
        if (tuple == null) {
            return false;
        }
        this.convertCurrentRow(tuple);
        return true;
    }

    private Object[] convertCurrentRow(ITuple tuple) {
        this.current = tuple.getAllValues();
        return this.current;
    }

    public void reset() {
        this.close();
        this.cursor = this.queryStorage();
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    private ITupleIterator queryStorage() {
        logger.debug("query storage...");
        this.setConnectionProperties();
        this.bindVariable(this.olapContext.filter);
        this.olapContext.resetSQLDigest();
        SQLDigest sqlDigest = this.olapContext.getSQLDigest();
        this.hackNoGroupByAggregation(sqlDigest);
        IStorageQuery storageEngine = StorageFactory.createQuery((IRealization)this.olapContext.realization);
        ITupleIterator iterator = storageEngine.search(this.olapContext.storageContext, sqlDigest, this.olapContext.returnTupleInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("return TupleIterator...");
        }
        return iterator;
    }

    private void bindVariable(TupleFilter filter) {
        if (filter == null) {
            return;
        }
        for (TupleFilter childFilter : filter.getChildren()) {
            this.bindVariable(childFilter);
        }
        if (filter instanceof CompareTupleFilter && this.optiqContext != null) {
            CompareTupleFilter compFilter = (CompareTupleFilter)filter;
            for (Map.Entry entry : compFilter.getVariables().entrySet()) {
                String variable = (String)entry.getKey();
                Object value = this.optiqContext.get(variable);
                if (value == null) continue;
                String str = value.toString();
                if (compFilter.getColumn().getType().isDateTimeFamily()) {
                    str = String.valueOf(DateFormat.stringToMillis((String)str));
                }
                compFilter.bindVariable(variable, (Object)str);
            }
        }
    }

    private void setConnectionProperties() {
        CalciteConnection conn = (CalciteConnection)this.optiqContext.getQueryProvider();
        Properties connProps = conn.getProperties();
        String propThreshold = connProps.getProperty("scan_threshold");
        int threshold = Integer.valueOf(propThreshold);
        this.olapContext.storageContext.setThreshold(threshold);
    }

    private void hackNoGroupByAggregation(SQLDigest sqlDigest) {
        if (!sqlDigest.groupbyColumns.isEmpty() || !sqlDigest.metricColumns.isEmpty()) {
            return;
        }
        logger.info("No group by and aggregation found in this query, will hack some result for better look of output...");
        IRealization cube = this.olapContext.realization;
        boolean isSelectAll = sqlDigest.allColumns.isEmpty() || sqlDigest.allColumns.equals(sqlDigest.filterColumns);
        for (TblColRef col : cube.getAllColumns()) {
            if (!col.getTable().equals(sqlDigest.factTable) || !cube.getAllDimensions().contains(col) && !isSelectAll) continue;
            sqlDigest.allColumns.add(col);
        }
        for (TblColRef col : sqlDigest.allColumns) {
            if (cube.getAllDimensions().contains(col)) {
                sqlDigest.groupbyColumns.add(col);
                continue;
            }
            ParameterDesc colParameter = new ParameterDesc();
            colParameter.setType("column");
            colParameter.setValue(col.getName());
            FunctionDesc sumFunc = new FunctionDesc();
            sumFunc.setExpression("SUM");
            sumFunc.setParameter(colParameter);
            boolean measureHasSum = false;
            for (MeasureDesc colMeasureDesc : cube.getMeasures()) {
                if (!colMeasureDesc.getFunction().equals((Object)sumFunc)) continue;
                measureHasSum = true;
                break;
            }
            if (measureHasSum) {
                sqlDigest.aggregations.add(sumFunc);
            } else {
                logger.warn("SUM is not defined for measure column " + col + ", output will be meaningless.");
            }
            sqlDigest.metricColumns.add(col);
        }
    }
}

