/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.query.relnode.OLAPContext;

public class HiveEnumerator
implements Enumerator<Object[]> {
    private final OLAPContext olapContext;
    private final Object[] current;
    private ResultSet rs;
    private Connection conn;

    public HiveEnumerator(OLAPContext olapContext) {
        this.olapContext = olapContext;
        this.current = new Object[olapContext.returnTupleInfo.size()];
    }

    public Object[] current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.rs == null) {
            this.rs = this.executeQuery();
        }
        return this.populateResult();
    }

    private ResultSet executeQuery() {
        String url = this.olapContext.olapSchema.getStarSchemaUrl();
        String user = this.olapContext.olapSchema.getStarSchemaUser();
        String pwd = this.olapContext.olapSchema.getStarSchemaPassword();
        String sql = this.olapContext.sql;
        Statement stmt = null;
        try {
            this.conn = DriverManager.getConnection(url, user, pwd);
            stmt = this.conn.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            return resultSet;
        }
        catch (SQLException e) {
            throw new IllegalStateException(url + " can't execute query " + sql, e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            stmt = null;
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                this.conn = null;
            }
        }
    }

    private boolean populateResult() {
        try {
            boolean hasNext = this.rs.next();
            if (hasNext) {
                List allFields = this.olapContext.returnTupleInfo.getAllFields();
                for (int i = 0; i < allFields.size(); ++i) {
                    Object value;
                    this.current[i] = value = this.rs.getObject(((String)allFields.get(i)).toLowerCase());
                }
            }
            return hasNext;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Can't populate result!", e);
        }
    }

    public void reset() {
        this.close();
        this.rs = this.executeQuery();
    }

    public void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Can't close ResultSet!", e);
        }
    }
}

