/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.util.ConversionUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.model.DatabaseDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.query.schema.OLAPSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPSchemaFactory
implements SchemaFactory {
    public static final Logger logger = LoggerFactory.getLogger(OLAPSchemaFactory.class);
    private static final String SCHEMA_PROJECT = "project";

    public Schema create(SchemaPlus parentSchema, String schemaName, Map<String, Object> operand) {
        String project = (String)operand.get(SCHEMA_PROJECT);
        OLAPSchema newSchema = new OLAPSchema(project, schemaName);
        return newSchema;
    }

    public static File createTempOLAPJson(String project, KylinConfig config) {
        project = ProjectInstance.getNormalizedProjectName((String)project);
        Set tables = ProjectManager.getInstance((KylinConfig)config).listExposedTables(project);
        HashMap schemaCounts = DatabaseDesc.extractDatabaseOccurenceCounts((Set)tables);
        String majoritySchemaName = "";
        int majoritySchemaCount = 0;
        for (Map.Entry e : schemaCounts.entrySet()) {
            if (((String)e.getKey()).equalsIgnoreCase("default")) {
                majoritySchemaCount = Integer.MAX_VALUE;
                majoritySchemaName = (String)e.getKey();
            }
            if ((Integer)e.getValue() < majoritySchemaCount) continue;
            majoritySchemaCount = (Integer)e.getValue();
            majoritySchemaName = (String)e.getKey();
        }
        try {
            File tmp = File.createTempFile("olap_model_", ".json");
            FileWriter out = new FileWriter(tmp);
            out.write("{\n");
            out.write("    \"version\": \"1.0\",\n");
            out.write("    \"defaultSchema\": \"" + majoritySchemaName + "\",\n");
            out.write("    \"schemas\": [\n");
            int counter = 0;
            for (String schemaName : schemaCounts.keySet()) {
                out.write("        {\n");
                out.write("            \"type\": \"custom\",\n");
                out.write("            \"name\": \"" + schemaName + "\",\n");
                out.write("            \"factory\": \"org.apache.kylin.query.schema.OLAPSchemaFactory\",\n");
                out.write("            \"operand\": {\n");
                out.write("                \"project\": \"" + project + "\"\n");
                out.write("            },\n");
                out.write("            \"functions\": [\n");
                out.write("               {\n");
                out.write("                   name: 'MASSIN',\n");
                out.write("                   className: 'org.apache.kylin.query.udf.MassInUDF'\n");
                out.write("               }\n");
                out.write("              ]\n");
                out.write("        }\n");
                if (++counter == schemaCounts.size()) continue;
                out.write(",\n");
            }
            out.write("    ]\n");
            out.write("}\n");
            out.close();
            tmp.deleteOnExit();
            logger.info("Schema json:" + StringUtils.join((Collection)FileUtils.readLines((File)tmp), (String)"\n"));
            return tmp;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("saffron.default.charset", ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.nationalcharset", ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.collation.name", ConversionUtil.NATIVE_UTF16_CHARSET_NAME + "$en_US");
    }
}

