/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metadata.realization.SQLDigest;

public class Candidate
implements Comparable<Candidate> {
    static final Map<RealizationType, Integer> PRIORITIES = Maps.newHashMap();
    IRealization realization;
    SQLDigest sqlDigest;
    int priority;
    CapabilityResult capability;

    public static void setPriorities(Map<RealizationType, Integer> priorities) {
        PRIORITIES.clear();
        PRIORITIES.putAll(priorities);
    }

    public Candidate(IRealization realization, SQLDigest sqlDigest) {
        this.realization = realization;
        this.sqlDigest = sqlDigest;
        this.priority = PRIORITIES.get(realization.getType());
    }

    public IRealization getRealization() {
        return this.realization;
    }

    public SQLDigest getSqlDigest() {
        return this.sqlDigest;
    }

    public int getPriority() {
        return this.priority;
    }

    public CapabilityResult getCapability() {
        return this.capability;
    }

    public void setCapability(CapabilityResult capability) {
        this.capability = capability;
    }

    @Override
    public int compareTo(Candidate o) {
        int comp = this.priority - o.priority;
        if (comp != 0) {
            return comp;
        }
        comp = this.capability.cost - o.capability.cost;
        if (comp != 0) {
            return comp;
        }
        return 0;
    }

    static {
        PRIORITIES.put(RealizationType.HYBRID, 0);
        PRIORITIES.put(RealizationType.CUBE, 1);
        PRIORITIES.put(RealizationType.INVERTED_INDEX, 2);
    }
}

