/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.routing.NoRealizationFoundException;
import org.apache.kylin.query.routing.QueryRouter;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    public OLAPToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new OLAPToEnumerableConverter(this.getCluster(), traitSet, (RelNode)OLAPToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(1.0E100, 0.0, 0.0);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor enumImplementor, EnumerableRel.Prefer pref) {
        OLAPRel.OLAPImplementor olapImplementor = new OLAPRel.OLAPImplementor();
        olapImplementor.visitChild(this.getInput(), (RelNode)this);
        try {
            for (OLAPContext context : OLAPContext.getThreadLocalContexts()) {
                IRealization realization;
                if (context.firstTableScan == null) continue;
                context.realization = realization = QueryRouter.selectRealization(context);
            }
        }
        catch (NoRealizationFoundException e) {
            OLAPContext ctx0 = (OLAPContext)OLAPContext.getThreadLocalContexts().toArray()[0];
            if (ctx0 != null && ctx0.olapSchema.hasStarSchemaUrl()) {
                return this.buildHiveResult(enumImplementor, pref, ctx0);
            }
            throw e;
        }
        OLAPRel.RewriteImplementor rewriteImplementor = new OLAPRel.RewriteImplementor();
        rewriteImplementor.visitChild((RelNode)this, this.getInput());
        OLAPRel.JavaImplementor impl = new OLAPRel.JavaImplementor(enumImplementor);
        EnumerableRel inputAsEnum = impl.createEnumerable((OLAPRel)this.getInput());
        this.replaceInput(0, (RelNode)inputAsEnum);
        if (System.getProperty("calcite.debug") != null) {
            String dumpPlan = RelOptUtil.dumpPlan((String)"", (RelNode)this, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            System.out.println("EXECUTION PLAN AFTER REWRITE");
            System.out.println(dumpPlan);
        }
        return impl.visitChild(this, 0, inputAsEnum, pref);
    }

    private EnumerableRel.Result buildHiveResult(EnumerableRelImplementor enumImplementor, EnumerableRel.Prefer pref, OLAPContext context) {
        RelDataType hiveRowType = this.getRowType();
        context.setReturnTupleInfo(hiveRowType, null);
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)enumImplementor.getTypeFactory(), (RelDataType)hiveRowType, (JavaRowFormat)pref.preferArray());
        RelOptTable factTable = context.firstTableScan.getTable();
        EnumerableRel.Result result = enumImplementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)factTable.getExpression(OLAPTable.class), (String)"executeHiveQuery", (Expression[])new Expression[]{enumImplementor.getRootExpression()})));
        return result;
    }
}

