/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableJoin;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPJoinRel
extends EnumerableJoin
implements OLAPRel {
    private static final String[] COLUMN_ARRAY_MARKER = new String[0];
    private OLAPContext context;
    private ColumnRowType columnRowType;
    private boolean isTopJoin;
    private boolean hasSubQuery;
    private static Constructor<EnumerableJoin> constr;

    public OLAPJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, leftKeys, rightKeys, variablesSet, joinType);
        Preconditions.checkArgument((this.getConvention() == OLAPRel.CONVENTION ? 1 : 0) != 0);
        this.rowType = this.getRowType();
        this.isTopJoin = false;
    }

    public EnumerableJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)this.condition);
        assert (joinInfo.isEqui());
        try {
            return new OLAPJoinRel(this.getCluster(), traitSet, left, right, this.condition, joinInfo.leftKeys, joinInfo.rightKeys, (Set<CorrelationId>)this.variablesSet, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return super.estimateRowCount(mq) * 0.1;
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        if (!(implementor.getParentNode() instanceof OLAPJoinRel)) {
            implementor.allocateContext();
        }
        this.context = implementor.getContext();
        this.isTopJoin = !this.context.hasJoin;
        this.context.hasJoin = true;
        implementor.visitChild(this.left, this);
        if (this.context != implementor.getContext() || ((OLAPRel)this.left).hasSubQuery()) {
            this.hasSubQuery = true;
            implementor.freeContext();
        }
        implementor.visitChild(this.right, this);
        if (this.context != implementor.getContext() || ((OLAPRel)this.right).hasSubQuery()) {
            this.hasSubQuery = true;
            implementor.freeContext();
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.isTopJoin) {
            this.context.afterJoin = true;
        }
        if (!this.hasSubQuery) {
            this.context.allColumns.clear();
            RexCall condition = (RexCall)this.getCondition();
            JoinDesc join = this.buildJoin(condition);
            JoinRelType joinRelType = this.getJoinType();
            String joinType = joinRelType == JoinRelType.INNER ? "INNER" : (joinRelType == JoinRelType.LEFT ? "LEFT" : null);
            join.setType(joinType);
            this.context.joins.add(join);
        }
    }

    private ColumnRowType buildColumnRowType() {
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        OLAPRel olapLeft = (OLAPRel)this.left;
        ColumnRowType leftColumnRowType = olapLeft.getColumnRowType();
        columns.addAll(leftColumnRowType.getAllColumns());
        OLAPRel olapRight = (OLAPRel)this.right;
        ColumnRowType rightColumnRowType = olapRight.getColumnRowType();
        columns.addAll(rightColumnRowType.getAllColumns());
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    private JoinDesc buildJoin(RexCall condition) {
        HashMap<TblColRef, TblColRef> joinColumns = new HashMap<TblColRef, TblColRef>();
        this.translateJoinColumn(condition, joinColumns);
        ArrayList<String> pks = new ArrayList<String>();
        ArrayList<TblColRef> pkCols = new ArrayList<TblColRef>();
        ArrayList<String> fks = new ArrayList<String>();
        ArrayList<TblColRef> fkCols = new ArrayList<TblColRef>();
        String factTable = this.context.firstTableScan.getTableName();
        for (Map.Entry columnPair : joinColumns.entrySet()) {
            TblColRef fromCol = (TblColRef)columnPair.getKey();
            TblColRef toCol = (TblColRef)columnPair.getValue();
            if (factTable.equalsIgnoreCase(fromCol.getTable())) {
                fks.add(fromCol.getName());
                fkCols.add(fromCol);
                pks.add(toCol.getName());
                pkCols.add(toCol);
                continue;
            }
            fks.add(toCol.getName());
            fkCols.add(toCol);
            pks.add(fromCol.getName());
            pkCols.add(fromCol);
        }
        JoinDesc join = new JoinDesc();
        join.setForeignKey(fks.toArray(COLUMN_ARRAY_MARKER));
        join.setForeignKeyColumns(fkCols.toArray(new TblColRef[fkCols.size()]));
        join.setPrimaryKey(pks.toArray(COLUMN_ARRAY_MARKER));
        join.setPrimaryKeyColumns(pkCols.toArray(new TblColRef[pkCols.size()]));
        return join;
    }

    private void translateJoinColumn(RexCall condition, Map<TblColRef, TblColRef> joinColumns) {
        SqlKind kind = condition.getOperator().getKind();
        if (kind == SqlKind.AND) {
            for (RexNode operand : condition.getOperands()) {
                RexCall subCond = (RexCall)operand;
                this.translateJoinColumn(subCond, joinColumns);
            }
        } else if (kind == SqlKind.EQUALS) {
            List operands = condition.getOperands();
            RexInputRef op0 = (RexInputRef)operands.get(0);
            TblColRef col0 = this.columnRowType.getColumnByIndex(op0.getIndex());
            RexInputRef op1 = (RexInputRef)operands.get(1);
            TblColRef col1 = this.columnRowType.getColumnByIndex(op1.getIndex());
            joinColumns.put(col0, col1);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        if (this.hasSubQuery) {
            try {
                return (EnumerableRel)constr.newInstance(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), inputs.get(0), inputs.get(1), this.condition, this.leftKeys, this.rightKeys, this.variablesSet, this.joinType);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't create EnumerableJoin!", e);
            }
        }
        return this;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        RelOptTable factTable = this.context.firstTableScan.getTable();
        MethodCallExpression exprCall = Expressions.call((Expression)factTable.getExpression(OLAPTable.class), (String)"executeOLAPQuery", (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.context.id)});
        return implementor.result(physType, Blocks.toBlock((Node)exprCall));
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.left);
        implementor.visitChild(this, this.right);
        this.rowType = this.deriveRowType();
        if (this.isTopJoin && OLAPRel.RewriteImplementor.needRewrite(this.context)) {
            int paramIndex = this.rowType.getFieldList().size();
            LinkedList<RelDataTypeFieldImpl> newFieldList = new LinkedList<RelDataTypeFieldImpl>();
            for (Map.Entry<String, RelDataType> rewriteField : this.context.rewriteFields.entrySet()) {
                String fieldName = rewriteField.getKey();
                if (this.rowType.getField(fieldName, true, false) != null) continue;
                RelDataType fieldType = rewriteField.getValue();
                RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, paramIndex++, fieldType);
                newFieldList.add(newField);
            }
            RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
            fieldInfo.addAll((Iterable)this.rowType.getFieldList());
            fieldInfo.addAll(newFieldList);
            this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
            this.columnRowType = this.buildColumnRowType();
        }
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasSubQuery() {
        return this.hasSubQuery;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    static {
        try {
            constr = EnumerableJoin.class.getDeclaredConstructor(RelOptCluster.class, RelTraitSet.class, RelNode.class, RelNode.class, RexNode.class, ImmutableIntList.class, ImmutableIntList.class, Set.class, JoinRelType.class);
            constr.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

