/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.calcite.jdbc.Driver;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.schema.OLAPSchemaFactory;

public class QueryCli {
    private static final Option OPTION_METADATA;
    private static final Option OPTION_SQL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(OPTION_METADATA);
        options.addOption(OPTION_SQL);
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(options, args);
        KylinConfig config = KylinConfig.createInstanceFromUri((String)commandLine.getOptionValue(OPTION_METADATA.getOpt()));
        String sql = commandLine.getOptionValue(OPTION_SQL.getOpt());
        Class.forName(Driver.class.getName());
        File olapTmp = OLAPSchemaFactory.createTempOLAPJson(null, config);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DriverManager.getConnection("jdbc:calcite:model=" + olapTmp.getAbsolutePath());
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            int n = 0;
            ResultSetMetaData meta = rs.getMetaData();
            while (rs.next()) {
                ++n;
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    System.out.println(n + " - " + meta.getColumnLabel(i) + ":\t" + rs.getObject(i));
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    static {
        OptionBuilder.withArgName((String)"metadata url");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Metadata URL");
        OPTION_METADATA = OptionBuilder.create((String)"metadata");
        OptionBuilder.withArgName((String)"input sql");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"SQL");
        OPTION_SQL = OptionBuilder.create((String)"sql");
    }
}

