/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.query.enumerator.OLAPQuery;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.schema.OLAPSchema;

public class OLAPTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static Map<String, SqlTypeName> SQLTYPE_MAPPING = new HashMap<String, SqlTypeName>();
    private final OLAPSchema olapSchema;
    private final TableDesc sourceTable;
    private RelDataType rowType;
    private List<ColumnDesc> exposedColumns;

    public OLAPTable(OLAPSchema schema, TableDesc tableDesc) {
        super(Object[].class);
        this.olapSchema = schema;
        this.sourceTable = tableDesc;
        this.rowType = null;
    }

    public OLAPSchema getSchema() {
        return this.olapSchema;
    }

    public TableDesc getSourceTable() {
        return this.sourceTable;
    }

    public String getTableName() {
        return this.sourceTable.getIdentity();
    }

    public List<ColumnDesc> getExposedColumns() {
        return this.exposedColumns;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType == null) {
            this.exposedColumns = this.listSourceColumns();
            this.rowType = this.deriveRowType(typeFactory);
        }
        return this.rowType;
    }

    private RelDataType deriveRowType(RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        for (ColumnDesc column : this.exposedColumns) {
            RelDataType sqlType = OLAPTable.createSqlType(typeFactory, column.getType(), column.isNullable());
            sqlType = SqlTypeUtil.addCharsetAndCollation((RelDataType)sqlType, (RelDataTypeFactory)typeFactory);
            fieldInfo.add(column.getName(), sqlType);
        }
        return typeFactory.createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
    }

    public static RelDataType createSqlType(RelDataTypeFactory typeFactory, DataType dataType, boolean isNullable) {
        SqlTypeName sqlTypeName = SQLTYPE_MAPPING.get(dataType.getName());
        if (sqlTypeName == null) {
            throw new IllegalArgumentException("Unrecognized data type " + dataType);
        }
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        RelDataType result = precision >= 0 && scale >= 0 ? typeFactory.createSqlType(sqlTypeName, precision, scale) : (precision >= 0 ? typeFactory.createSqlType(sqlTypeName, precision) : typeFactory.createSqlType(sqlTypeName));
        result = isNullable ? typeFactory.createTypeWithNullability(result, true) : typeFactory.createTypeWithNullability(result, false);
        return result;
    }

    private List<ColumnDesc> listSourceColumns() {
        ProjectManager mgr = ProjectManager.getInstance((KylinConfig)this.olapSchema.getConfig());
        ArrayList tableColumns = Lists.newArrayList((Iterable)mgr.listExposedColumns(this.olapSchema.getProjectName(), this.sourceTable.getIdentity()));
        List countMeasures = mgr.listEffectiveMeasures(this.olapSchema.getProjectName(), this.sourceTable.getIdentity(), true);
        HashSet<String> metFields = new HashSet<String>();
        ArrayList metricColumns = Lists.newArrayList();
        for (MeasureDesc m : countMeasures) {
            FunctionDesc func = m.getFunction();
            String fieldName = func.getRewriteFieldName();
            if (metFields.contains(fieldName)) continue;
            metFields.add(fieldName);
            ColumnDesc fakeCountCol = new ColumnDesc();
            fakeCountCol.setName(fieldName);
            fakeCountCol.setDatatype(func.getRewriteFieldType().toString());
            if (func.isCount()) {
                fakeCountCol.setNullable(false);
            }
            fakeCountCol.init(this.sourceTable);
            metricColumns.add(fakeCountCol);
        }
        HashSet updateColumns = Sets.newHashSet();
        for (MeasureDesc m : mgr.listEffectiveMeasures(this.olapSchema.getProjectName(), this.sourceTable.getIdentity(), false)) {
            FunctionDesc func;
            if (!m.getFunction().isSum() || !(func = m.getFunction()).getReturnDataType().isBigInt() || !func.getRewriteFieldType().isIntegerFamily()) continue;
            updateColumns.add(((TblColRef)func.getParameter().getColRefs().get(0)).getColumnDesc());
        }
        for (ColumnDesc upgrade : updateColumns) {
            int index = tableColumns.indexOf(upgrade);
            ((ColumnDesc)tableColumns.get(index)).setDatatype("bigint");
        }
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)tableColumns, (Iterable)metricColumns));
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = this.identityList(fieldCount);
        return new OLAPTableScan(context.getCluster(), relOptTable, this, fields);
    }

    private int[] identityList(int n) {
        int[] integers = new int[n];
        for (int i = 0; i < n; ++i) {
            integers[i] = i;
        }
        return integers;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

            public Enumerator<T> enumerator() {
                OLAPQuery query = new OLAPQuery(OLAPQuery.EnumeratorTypeEnum.INDEX, 0);
                return query.enumerator();
            }
        };
    }

    public Statistic getStatistic() {
        ArrayList keys = new ArrayList();
        return Statistics.of((double)100.0, keys);
    }

    public String toString() {
        return "OLAPTable {" + this.getTableName() + "}";
    }

    public Enumerable<Object[]> executeIndexQuery(DataContext optiqContext, int ctxSeq) {
        return new OLAPQuery(optiqContext, OLAPQuery.EnumeratorTypeEnum.INDEX, ctxSeq);
    }

    public Enumerable<Object[]> executeLookupTableQuery(DataContext optiqContext, int ctxSeq) {
        return new OLAPQuery(optiqContext, OLAPQuery.EnumeratorTypeEnum.LOOKUP_TABLE, ctxSeq);
    }

    public Enumerable<Object[]> executeHiveQuery(DataContext optiqContext, int ctxSeq) {
        return new OLAPQuery(optiqContext, OLAPQuery.EnumeratorTypeEnum.HIVE, ctxSeq);
    }

    static {
        SQLTYPE_MAPPING.put("char", SqlTypeName.CHAR);
        SQLTYPE_MAPPING.put("varchar", SqlTypeName.VARCHAR);
        SQLTYPE_MAPPING.put("boolean", SqlTypeName.BOOLEAN);
        SQLTYPE_MAPPING.put("integer", SqlTypeName.INTEGER);
        SQLTYPE_MAPPING.put("tinyint", SqlTypeName.TINYINT);
        SQLTYPE_MAPPING.put("smallint", SqlTypeName.SMALLINT);
        SQLTYPE_MAPPING.put("bigint", SqlTypeName.BIGINT);
        SQLTYPE_MAPPING.put("decimal", SqlTypeName.DECIMAL);
        SQLTYPE_MAPPING.put("numeric", SqlTypeName.DECIMAL);
        SQLTYPE_MAPPING.put("float", SqlTypeName.FLOAT);
        SQLTYPE_MAPPING.put("real", SqlTypeName.REAL);
        SQLTYPE_MAPPING.put("double", SqlTypeName.DOUBLE);
        SQLTYPE_MAPPING.put("date", SqlTypeName.DATE);
        SQLTYPE_MAPPING.put("time", SqlTypeName.TIME);
        SQLTYPE_MAPPING.put("timestamp", SqlTypeName.TIMESTAMP);
        SQLTYPE_MAPPING.put("any", SqlTypeName.ANY);
    }
}

