/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.QueryRouter;
import org.apache.kylin.query.routing.rules.RealizationSortRule;
import org.apache.kylin.query.routing.rules.RemoveUncapableRealizationsRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoutingRule {
    private static final Logger logger = LoggerFactory.getLogger(QueryRouter.class);
    private static List<RoutingRule> rules = Lists.newLinkedList();

    public static void applyRules(List<Candidate> candidates) {
        for (RoutingRule rule : rules) {
            logger.info("Realizations order before: " + RoutingRule.getPrintableText(candidates));
            logger.info("Applying rule : " + rule);
            rule.apply(candidates);
            logger.info("Realizations order after: " + RoutingRule.getPrintableText(candidates));
            logger.info("===================================================");
        }
    }

    public static String getPrintableText(List<Candidate> candidates) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Candidate candidate : candidates) {
            IRealization r = candidate.realization;
            sb.append(r.getName());
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) != '[') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static void registerRule(RoutingRule rule, int applyOrder) {
        if (applyOrder > rules.size()) {
            logger.warn("apply order " + applyOrder + "  is larger than rules size " + rules.size() + ", will put the new rule at the end");
            rules.add(rule);
        }
        rules.add(applyOrder, rule);
    }

    public static void removeRule(RoutingRule rule) {
        Iterator<RoutingRule> iter = rules.iterator();
        while (iter.hasNext()) {
            RoutingRule r = iter.next();
            if (r.getClass() != rule.getClass()) continue;
            iter.remove();
        }
    }

    protected List<Integer> findRealizationsOf(List<IRealization> realizations, RealizationType type) {
        ArrayList itemIndexes = Lists.newArrayList();
        for (int i = 0; i < realizations.size(); ++i) {
            if (realizations.get(i).getType() != type) continue;
            itemIndexes.add(i);
        }
        return itemIndexes;
    }

    public String toString() {
        return this.getClass().toString();
    }

    public abstract void apply(List<Candidate> var1);

    static {
        rules.add(new RemoveUncapableRealizationsRule());
        rules.add(new RealizationSortRule());
    }
}

