/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateJoinTransposeRule;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.JoinPushExpressionsRule;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.SortJoinTransposeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.optrule.OLAPAggregateRule;
import org.apache.kylin.query.optrule.OLAPFilterRule;
import org.apache.kylin.query.optrule.OLAPJoinRule;
import org.apache.kylin.query.optrule.OLAPLimitRule;
import org.apache.kylin.query.optrule.OLAPProjectRule;
import org.apache.kylin.query.optrule.OLAPSortRule;
import org.apache.kylin.query.optrule.OLAPToEnumerableConverterRule;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.schema.OLAPSchema;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPTableScan
extends TableScan
implements OLAPRel,
EnumerableRel {
    private final OLAPTable olapTable;
    private final String tableName;
    private final int[] fields;
    private ColumnRowType columnRowType;
    private OLAPContext context;

    public OLAPTableScan(RelOptCluster cluster, RelOptTable table, OLAPTable olapTable, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)OLAPRel.CONVENTION), table);
        this.olapTable = olapTable;
        this.fields = fields;
        this.tableName = olapTable.getTableName();
        this.rowType = this.getRowType();
    }

    public OLAPTable getOlapTable() {
        return this.olapTable;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int[] getFields() {
        return this.fields;
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    void overrideContext(OLAPContext context) {
        this.context = context;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkArgument((boolean)inputs.isEmpty());
        return new OLAPTableScan(this.getCluster(), this.table, this.olapTable, this.fields);
    }

    public void register(RelOptPlanner planner) {
        OLAPContext.clearThreadLocalContexts();
        planner.addRule((RelOptRule)OLAPToEnumerableConverterRule.INSTANCE);
        planner.addRule(OLAPFilterRule.INSTANCE);
        planner.addRule(OLAPProjectRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPAggregateRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPJoinRule.INSTANCE);
        planner.addRule(OLAPLimitRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPSortRule.INSTANCE);
        planner.addRule((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE);
        planner.addRule((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
        planner.addRule((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE);
        planner.addRule((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE);
        planner.removeRule((RelOptRule)FilterJoinRule.FILTER_ON_JOIN);
        planner.removeRule((RelOptRule)FilterJoinRule.JOIN);
        planner.removeRule((RelOptRule)JoinCommuteRule.INSTANCE);
        planner.removeRule(JoinPushThroughJoinRule.LEFT);
        planner.removeRule(JoinPushThroughJoinRule.RIGHT);
        planner.removeRule((RelOptRule)AggregateJoinTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)AggregateProjectMergeRule.INSTANCE);
        planner.removeRule((RelOptRule)FilterProjectTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)SortJoinTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)JoinPushExpressionsRule.INSTANCE);
        planner.removeRule((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE);
        planner.removeRule((RelOptRule)AbstractConverter.ExpandConversionRule.INSTANCE);
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int field : this.fields) {
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)builder);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("fields", (Object)Primitive.asList((int[])this.fields));
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        if (implementor.getContext() == null || !(implementor.getParentNode() instanceof OLAPJoinRel)) {
            implementor.allocateContext();
        }
        this.columnRowType = this.buildColumnRowType();
        this.context = implementor.getContext();
        if (this.context.olapSchema == null) {
            OLAPSchema schema;
            this.context.olapSchema = schema = this.olapTable.getSchema();
            this.context.storageContext.setConnUrl(schema.getStorageUrl());
        }
        if (this.context.firstTableScan == null) {
            this.context.firstTableScan = this;
        }
        this.context.olapRowType = this.rowType;
    }

    private ColumnRowType buildColumnRowType() {
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        for (ColumnDesc sourceColumn : this.olapTable.getExposedColumns()) {
            TblColRef colRef = new TblColRef(sourceColumn);
            columns.add(colRef);
        }
        return new ColumnRowType(columns);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return this;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.rowType, (JavaRowFormat)pref.preferArray());
        String execFunction = this.genExecFunc();
        MethodCallExpression exprCall = Expressions.call((Expression)this.table.getExpression(OLAPTable.class), (String)execFunction, (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.context.id)});
        return implementor.result(physType, Blocks.toBlock((Node)exprCall));
    }

    private String genExecFunc() {
        if (!this.context.hasJoin && !this.tableName.equalsIgnoreCase(this.context.realization.getFactTable())) {
            return "executeLookupTableQuery";
        }
        return "executeIndexQuery";
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        Map<String, RelDataType> rewriteFields = this.context.rewriteFields;
        if (implementor.getParentContext() != null) {
            rewriteFields = implementor.getParentContext().rewriteFields;
        }
        for (Map.Entry<String, RelDataType> rewriteField : rewriteFields.entrySet()) {
            String fieldName = rewriteField.getKey();
            RelDataTypeField field = this.rowType.getField(fieldName, true, false);
            if (field == null) continue;
            RelDataType fieldType = field.getType();
            rewriteField.setValue(fieldType);
        }
    }

    @Override
    public boolean hasSubQuery() {
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }
}

