/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.DataContext;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.storage.IStorageEngine;
import org.apache.kylin.storage.StorageEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeEnumerator
implements Enumerator<Object[]> {
    private static final Logger logger = LoggerFactory.getLogger(CubeEnumerator.class);
    private final OLAPContext olapContext;
    private final DataContext optiqContext;
    private final Object[] current;
    private ITupleIterator cursor;
    private int[] fieldIndexes;
    private List<String> tupleFieldsSnapshot;

    public CubeEnumerator(OLAPContext olapContext, DataContext optiqContext) {
        this.olapContext = olapContext;
        this.optiqContext = optiqContext;
        this.current = new Object[olapContext.olapRowType.getFieldCount()];
        this.cursor = null;
        this.fieldIndexes = null;
    }

    public Object[] current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.cursor == null) {
            this.cursor = this.queryStorage();
        }
        if (!this.cursor.hasNext()) {
            return false;
        }
        ITuple tuple = this.cursor.next();
        if (tuple == null) {
            return false;
        }
        this.convertCurrentRow(tuple);
        return true;
    }

    public void reset() {
        this.close();
        this.cursor = this.queryStorage();
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    private Object[] convertCurrentRow(ITuple tuple) {
        if (this.tupleFieldsSnapshot != tuple.getAllFields()) {
            List fields = tuple.getAllFields();
            int size = fields.size();
            this.fieldIndexes = new int[size];
            for (int i = 0; i < size; ++i) {
                String field = (String)fields.get(i);
                RelDataTypeField relField = this.olapContext.olapRowType.getField(field, true, false);
                this.fieldIndexes[i] = relField != null ? relField.getIndex() : -1;
            }
            this.tupleFieldsSnapshot = tuple.getAllFields();
        }
        Object[] values = tuple.getAllValues();
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            Object value = values[i];
            int index = this.fieldIndexes[i];
            if (index < 0) continue;
            this.current[index] = value;
        }
        return this.current;
    }

    private ITupleIterator queryStorage() {
        logger.debug("query storage...");
        this.setConnectionProperties();
        this.bindVariable(this.olapContext.filter);
        SQLDigest sqlDigest = this.olapContext.getSQLDigest();
        this.hackNoGroupByAggregation(sqlDigest);
        IStorageEngine storageEngine = StorageEngineFactory.getStorageEngine((IRealization)this.olapContext.realization);
        ITupleIterator iterator = storageEngine.search(this.olapContext.storageContext, sqlDigest);
        if (logger.isDebugEnabled()) {
            logger.debug("return TupleIterator...");
        }
        this.fieldIndexes = null;
        this.tupleFieldsSnapshot = null;
        return iterator;
    }

    private void bindVariable(TupleFilter filter) {
        if (filter == null) {
            return;
        }
        for (TupleFilter childFilter : filter.getChildren()) {
            this.bindVariable(childFilter);
        }
        if (filter instanceof CompareTupleFilter && this.optiqContext != null) {
            CompareTupleFilter compFilter = (CompareTupleFilter)filter;
            for (Map.Entry entry : compFilter.getVariables().entrySet()) {
                String variable = (String)entry.getKey();
                Object value = this.optiqContext.get(variable);
                if (value == null) continue;
                compFilter.bindVariable(variable, value.toString());
            }
        }
    }

    private void setConnectionProperties() {
        CalciteConnection conn = (CalciteConnection)this.optiqContext.getQueryProvider();
        Properties connProps = conn.getProperties();
        String propThreshold = connProps.getProperty("scan_threshold");
        int threshold = Integer.valueOf(propThreshold);
        this.olapContext.storageContext.setThreshold(threshold);
    }

    private void hackNoGroupByAggregation(SQLDigest sqlDigest) {
        if (!sqlDigest.groupbyColumns.isEmpty() || !sqlDigest.metricColumns.isEmpty()) {
            return;
        }
        logger.info("No group by and aggregation found in this query, will hack some result for better look of output...");
        IRealization cube = this.olapContext.realization;
        boolean isSelectAll = sqlDigest.allColumns.isEmpty() || sqlDigest.allColumns.equals(sqlDigest.filterColumns);
        for (TblColRef col : cube.getAllColumns()) {
            if (!col.getTable().equals(sqlDigest.factTable) || !cube.getAllDimensions().contains(col) && !isSelectAll) continue;
            sqlDigest.allColumns.add(col);
        }
        for (TblColRef col : sqlDigest.allColumns) {
            if (cube.getAllDimensions().contains(col)) {
                sqlDigest.groupbyColumns.add(col);
                continue;
            }
            ParameterDesc colParameter = new ParameterDesc();
            colParameter.setType("column");
            colParameter.setValue(col.getName());
            FunctionDesc sumFunc = new FunctionDesc();
            sumFunc.setExpression("SUM");
            sumFunc.setParameter(colParameter);
            boolean measureHasSum = false;
            for (MeasureDesc colMeasureDesc : cube.getMeasures()) {
                if (!colMeasureDesc.getFunction().equals((Object)sumFunc)) continue;
                measureHasSum = true;
                break;
            }
            if (measureHasSum) {
                sqlDigest.aggregations.add(sumFunc);
            } else {
                logger.warn("SUM is not defined for measure column " + col + ", output will be meaningless.");
            }
            sqlDigest.metricColumns.add(col);
        }
    }
}

