/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPSchema
extends AbstractSchema {
    private KylinConfig config;
    private String projectName;
    private String schemaName;
    private String storageUrl;
    private String starSchemaUrl;
    private String starSchemaUser;
    private String starSchemaPassword;

    private void init() {
        this.config = KylinConfig.getInstanceFromEnv();
        this.storageUrl = this.config.getStorageUrl();
        this.starSchemaUrl = this.config.getHiveUrl();
        this.starSchemaUser = this.config.getHiveUser();
        this.starSchemaPassword = this.config.getHivePassword();
    }

    public OLAPSchema(String project, String schemaName) {
        this.projectName = ProjectInstance.getNormalizedProjectName((String)project);
        this.schemaName = schemaName;
        this.init();
    }

    protected Map<String, Table> getTableMap() {
        return this.buildTableMap();
    }

    private Map<String, Table> buildTableMap() {
        HashMap<String, Table> olapTables = new HashMap<String, Table>();
        Set projectTables = ProjectManager.getInstance((KylinConfig)this.config).listExposedTables(this.projectName);
        for (TableDesc tableDesc : projectTables) {
            if (!tableDesc.getDatabase().equals(this.schemaName)) continue;
            String tableName = tableDesc.getName();
            OLAPTable table = new OLAPTable(this, tableDesc);
            olapTables.put(tableName, (Table)table);
        }
        return olapTables;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getStorageUrl() {
        return this.storageUrl;
    }

    public boolean hasStarSchemaUrl() {
        return this.starSchemaUrl != null && !this.starSchemaUrl.isEmpty();
    }

    public String getStarSchemaUrl() {
        return this.starSchemaUrl;
    }

    public String getStarSchemaUser() {
        return this.starSchemaUser;
    }

    public String getStarSchemaPassword() {
        return this.starSchemaPassword;
    }

    public MetadataManager getMetadataManager() {
        return MetadataManager.getInstance((KylinConfig)this.config);
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public CubeManager getCubeManager() {
        return CubeManager.getInstance((KylinConfig)this.config);
    }
}

