/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing.RoutingRules;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.routing.RoutingRule;

public class RealizationPriorityRule
extends RoutingRule {
    static Map<RealizationType, Integer> priorities = Maps.newHashMap();

    public static void setPriorities(Map<RealizationType, Integer> priorities) {
        RealizationPriorityRule.priorities = priorities;
    }

    @Override
    public void apply(List<IRealization> realizations, OLAPContext olapContext) {
        Collections.sort(realizations, new Comparator<IRealization>(){

            @Override
            public int compare(IRealization o1, IRealization o2) {
                int i1 = priorities.get(o1.getType());
                int i2 = priorities.get(o2.getType());
                return i1 - i2;
            }
        });
    }

    static {
        priorities.put(RealizationType.CUBE, 1);
        priorities.put(RealizationType.HYBRID, 1);
        priorities.put(RealizationType.INVERTED_INDEX, 2);
    }
}

