/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing.RoutingRules;

import java.util.Collection;
import java.util.List;
import org.apache.kylin.cube.CubeCapabilityChecker;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.routing.RoutingRule;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdjustForWeeklyMatchedRealization
extends RoutingRule {
    private static final Logger logger = LoggerFactory.getLogger(AdjustForWeeklyMatchedRealization.class);

    @Override
    public void apply(List<IRealization> realizations, OLAPContext olapContext) {
        if (realizations.size() > 0) {
            HybridInstance hybrid;
            IRealization first = realizations.get(0);
            if (first instanceof HybridInstance && (hybrid = (HybridInstance)first).getRealizations()[0] instanceof CubeInstance) {
                first = hybrid.getRealizations()[0];
            }
            if (first instanceof CubeInstance) {
                CubeInstance cube = (CubeInstance)first;
                AdjustForWeeklyMatchedRealization.adjustOLAPContextIfNecessary(cube, olapContext);
            }
            if (first instanceof IIInstance) {
                IIInstance ii = (IIInstance)first;
                AdjustForWeeklyMatchedRealization.adjustOLAPContextIfNecessary(ii, olapContext);
            }
        }
    }

    private static void adjustOLAPContextIfNecessary(IIInstance ii, OLAPContext olapContext) {
        IIDesc iiDesc = ii.getDescriptor();
        List iiFuncs = iiDesc.listAllFunctions();
        AdjustForWeeklyMatchedRealization.convertAggregationToDimension(olapContext, iiFuncs, iiDesc.getFactTableName());
    }

    private static void adjustOLAPContextIfNecessary(CubeInstance cube, OLAPContext olapContext) {
        if (CubeCapabilityChecker.check((CubeInstance)cube, (SQLDigest)olapContext.getSQLDigest(), (boolean)false)) {
            return;
        }
        CubeDesc cubeDesc = cube.getDescriptor();
        List cubeFuncs = cubeDesc.listAllFunctions();
        AdjustForWeeklyMatchedRealization.convertAggregationToDimension(olapContext, cubeFuncs, cubeDesc.getFactTable());
    }

    private static void convertAggregationToDimension(OLAPContext olapContext, Collection<FunctionDesc> availableAggregations, String factTableName) {
        for (FunctionDesc functionDesc : olapContext.aggregations) {
            if (availableAggregations.contains(functionDesc)) continue;
            TblColRef col = (TblColRef)functionDesc.getParameter().getColRefs().get(0);
            functionDesc.setDimensionAsMetric(true);
            olapContext.rewriteFields.remove(functionDesc.getRewriteFieldName());
            if (col != null) {
                olapContext.metricsColumns.remove(col);
                olapContext.groupByColumns.add(col);
            }
            logger.info("Adjust OLAPContext for " + functionDesc);
        }
    }
}

